/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.gui.core;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import nz.ac.waikato.cms.gui.core.BaseButtonWithDropDownMenu;
import nz.ac.waikato.cms.gui.core.BasePanel;

public class BaseSplitButton
extends BasePanel {
    protected JButton m_ButtonMain;
    protected BaseButtonWithDropDownMenu m_ButtonMenu;

    public BaseSplitButton() {
    }

    public BaseSplitButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public BaseSplitButton(String text) {
        this();
        this.setText(text);
    }

    public BaseSplitButton(Action a) {
        this();
        this.setAction(a);
    }

    public BaseSplitButton(String text, Icon icon) {
        this();
        this.setText(text);
        this.setIcon(icon);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ButtonMain = new JButton();
        this.add((Component)this.m_ButtonMain, "Center");
        this.m_ButtonMenu = new BaseButtonWithDropDownMenu();
        this.m_ButtonMenu.setEnabled(false);
        this.add((Component)this.m_ButtonMenu, "East");
    }

    public void setText(String value) {
        this.m_ButtonMain.setText(value);
    }

    public String getText() {
        return this.m_ButtonMain.getText();
    }

    public void setIcon(Icon value) {
        this.m_ButtonMain.setIcon(value);
    }

    public Icon getIcon() {
        return this.m_ButtonMain.getIcon();
    }

    public void setAction(Action value) {
        this.m_ButtonMain.setAction(value);
    }

    public Action getAction() {
        return this.m_ButtonMain.getAction();
    }

    public void add(Action value) {
        this.m_ButtonMenu.addToMenu(value);
        if (this.isEnabled()) {
            this.m_ButtonMenu.setEnabled(true);
        }
    }

    public void add(JMenuItem value) {
        this.m_ButtonMenu.addToMenu(value);
        if (this.isEnabled()) {
            this.m_ButtonMenu.setEnabled(true);
        }
    }

    public void addSeparator() {
        this.m_ButtonMenu.addSeparatorToMenu();
    }

    public boolean isButtonEnabled() {
        return this.m_ButtonMain.isEnabled();
    }

    public void setButtonEnabled(boolean value) {
        this.m_ButtonMain.setEnabled(value);
    }

    public boolean isAlwaysDropdown() {
        return false;
    }

    public void setAlwaysDropdown(boolean alwaysDropdown) {
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_ButtonMain.setEnabled(value);
        this.m_ButtonMenu.setEnabled(value);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ButtonMenu.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ButtonMenu.removeChangeListener(l);
    }
}

