/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import nz.ac.waikato.cms.locator.ClassPathTraversal;
import nz.ac.waikato.cms.locator.ClassTraversal;
import nz.ac.waikato.cms.locator.LoggingHelper;
import nz.ac.waikato.cms.locator.TraversalListener;

public class ClassCache
implements Serializable {
    private static final long serialVersionUID = -2973185784363491578L;
    public static final String PATTERN_ANONYMOUS = ".*\\$[0-9]+$";
    protected transient Logger m_Logger;
    protected Map<String, Set<String>> m_NameCache;
    protected Map<URL, Set<String>> m_ClasspathPartCache;
    protected Set<String> m_AbstractClasses;
    protected Pattern m_AnonymousCheck;

    public ClassCache() {
        this.initialize(new ClassPathTraversal());
    }

    public ClassCache(ClassTraversal traversal) {
        this.initialize(traversal == null ? new ClassPathTraversal() : traversal);
    }

    protected void initialize(ClassTraversal traversal) {
        Listener listener = new Listener();
        traversal.traverse(listener);
        this.m_NameCache = listener.getNameCache();
        this.m_ClasspathPartCache = listener.getClasspathPartCache();
        this.m_AbstractClasses = new HashSet<String>();
        this.m_AnonymousCheck = Pattern.compile(PATTERN_ANONYMOUS);
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = Logger.getLogger(this.getClass().getName());
            this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
        }
        return this.m_Logger;
    }

    public boolean remove(String classname) {
        for (URL part : this.m_ClasspathPartCache.keySet()) {
            this.m_ClasspathPartCache.get(part).remove(classname);
        }
        String pkgname = ClassPathTraversal.extractPackage(classname = ClassPathTraversal.cleanUp(classname));
        Set<String> names = this.m_NameCache.get(pkgname);
        if (names != null) {
            return names.remove(classname);
        }
        return false;
    }

    public void setAbstract(String classname, boolean value) {
        if (value) {
            this.m_AbstractClasses.add(classname);
        } else {
            this.m_AbstractClasses.remove(classname);
        }
    }

    public boolean isAbstract(String classname) {
        return this.m_AbstractClasses.contains(classname);
    }

    public boolean isAnonymous(String classname) {
        return this.m_AnonymousCheck.matcher(classname).matches();
    }

    public Iterator<String> packages() {
        return this.m_NameCache.keySet().iterator();
    }

    public Iterator<String> packages(String regexp) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regexp);
        for (String pkg : this.m_NameCache.keySet()) {
            if (!pattern.matcher(pkg).matches()) continue;
            result.add(pkg);
        }
        return result.iterator();
    }

    public Set<String> getClassnames(String pkgname) {
        return this.getClassnames(pkgname, false);
    }

    public Set<String> getClassnames(String pkgname, boolean excludeAbstract) {
        Set<Object> result = this.m_NameCache.containsKey(pkgname) ? this.m_NameCache.get(pkgname) : new HashSet();
        if (excludeAbstract && result.size() > 0) {
            result.removeAll(this.m_AbstractClasses);
        }
        return result;
    }

    public Iterator<URL> classpathParts() {
        return this.m_ClasspathPartCache.keySet().iterator();
    }

    public Iterator<URL> classpathParts(String regexp) {
        ArrayList<URL> result = new ArrayList<URL>();
        Pattern pattern = Pattern.compile(regexp);
        for (URL part : this.m_ClasspathPartCache.keySet()) {
            if (!pattern.matcher(part.toExternalForm()).matches()) continue;
            result.add(part);
        }
        return result.iterator();
    }

    public List<URL> classpathPartsForClass(Class cls) {
        return this.classpathPartsForClass(cls.getName());
    }

    public List<URL> classpathPartsForClass(String classname) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (URL part : this.m_ClasspathPartCache.keySet()) {
            if (!this.m_ClasspathPartCache.get(part).contains(classname)) continue;
            result.add(part);
        }
        return result;
    }

    public Set<String> getClassnames(URL part) {
        return this.getClassnames(part, false);
    }

    public Set<String> getClassnames(URL part, boolean excludeAbstract) {
        Set<Object> result = this.m_ClasspathPartCache.containsKey(part) ? this.m_ClasspathPartCache.get(part) : new HashSet();
        if (excludeAbstract && result.size() > 0) {
            result.removeAll(this.m_AbstractClasses);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.m_NameCache == null || this.m_NameCache.isEmpty();
    }

    public static void main(String[] args) {
        ClassCache cache = new ClassCache();
        System.out.println("--> Packages");
        Iterator<String> pkgs = cache.packages();
        ArrayList<String> pkgsSorted = new ArrayList<String>();
        while (pkgs.hasNext()) {
            pkgsSorted.add(pkgs.next());
        }
        Collections.sort(pkgsSorted);
        for (String pkg : pkgsSorted) {
            System.out.println(pkg + ": " + cache.getClassnames(pkg).size());
        }
        System.out.println("--> Packages (nz.*)");
        pkgs = cache.packages("nz.*");
        pkgsSorted = new ArrayList();
        while (pkgs.hasNext()) {
            pkgsSorted.add(pkgs.next());
        }
        Collections.sort(pkgsSorted);
        for (String pkg : pkgsSorted) {
            System.out.println(pkg + ": " + cache.getClassnames(pkg).size());
        }
        System.out.println("--> Classpath parts");
        Iterator<URL> parts = cache.classpathParts();
        ArrayList<URL> partsSorted = new ArrayList<URL>();
        while (parts.hasNext()) {
            partsSorted.add(parts.next());
        }
        Collections.sort(partsSorted, new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.toExternalForm().compareTo(o2.toExternalForm());
            }
        });
        for (URL part : partsSorted) {
            System.out.println(part + ": " + cache.getClassnames(part).size());
        }
        System.out.println("--> Classpath parts (.*classes.*)");
        parts = cache.classpathParts(".*classes.*");
        partsSorted = new ArrayList();
        while (parts.hasNext()) {
            partsSorted.add(parts.next());
        }
        Collections.sort(partsSorted, new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                return o1.toExternalForm().compareTo(o2.toExternalForm());
            }
        });
        for (URL part : partsSorted) {
            System.out.println(part + ": " + cache.getClassnames(part).size());
        }
    }

    public static class Listener
    implements TraversalListener {
        protected Map<String, Set<String>> m_NameCache = new HashMap<String, Set<String>>();
        protected Map<URL, Set<String>> m_ClasspathPartCache = new HashMap<URL, Set<String>>();
        protected transient Logger m_Logger;

        public synchronized Logger getLogger() {
            if (this.m_Logger == null) {
                this.m_Logger = Logger.getLogger(this.getClass().getName());
                this.m_Logger.setLevel(LoggingHelper.getLevel(this.getClass()));
            }
            return this.m_Logger;
        }

        @Override
        public void traversing(String classname, URL classPathPart) {
            String pkgname = ClassPathTraversal.extractPackage(classname);
            if (!this.m_NameCache.containsKey(pkgname)) {
                this.m_NameCache.put(pkgname, new HashSet());
            }
            this.m_NameCache.get(pkgname).add(classname);
            if (!this.m_ClasspathPartCache.containsKey(classPathPart)) {
                this.m_ClasspathPartCache.put(classPathPart, new HashSet());
            }
            this.m_ClasspathPartCache.get(classPathPart).add(classname);
        }

        public Map<String, Set<String>> getNameCache() {
            return this.m_NameCache;
        }

        public Map<URL, Set<String>> getClasspathPartCache() {
            return this.m_ClasspathPartCache;
        }
    }
}

