/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import nz.ac.waikato.cms.locator.AbstractClassTraversal;
import nz.ac.waikato.cms.locator.TraversalListener;

public class FixedClassListTraversal
extends AbstractClassTraversal {
    public static final String COMMENT = "#";
    protected List<String> m_Classnames;

    public FixedClassListTraversal(List<String> classnames) {
        this.m_Classnames = new ArrayList<String>(classnames);
    }

    public FixedClassListTraversal(InputStream inputStream) {
        this.m_Classnames = new ArrayList<String>();
        try {
            String line;
            if (inputStream == null) {
                throw new IOException("Input stream to read from is null!");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith(COMMENT)) continue;
                this.m_Classnames.add(line);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read class names from input stream!", e);
        }
    }

    @Override
    public void traverse(TraversalListener listener) {
        for (String classname : this.m_Classnames) {
            listener.traversing(classname, null);
        }
    }
}

