/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cms.locator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import nz.ac.waikato.cms.locator.AbstractClassTraversal;
import nz.ac.waikato.cms.locator.TraversalListener;

public class PropertiesBasedClassListTraversal
extends AbstractClassTraversal {
    protected List<String> m_Classnames = new ArrayList<String>();

    public PropertiesBasedClassListTraversal(Properties props) {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = "" + keys.nextElement();
            String list = props.getProperty(key, "");
            if (list.isEmpty()) continue;
            try {
                for (String item : list.split(",")) {
                    if ((item = item.trim()).isEmpty()) continue;
                    this.m_Classnames.add(item);
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to process class names from key: " + key, e);
            }
        }
    }

    @Override
    public void traverse(TraversalListener listener) {
        for (String classname : this.m_Classnames) {
            listener.traversing(classname, null);
        }
    }
}

