/*
 * Decompiled with CFR 0.152.
 */
package com.mpc.scalats.core;

import com.mpc.scalats.configuration.Config;
import com.mpc.scalats.core.ScalaModel;
import com.mpc.scalats.core.ScalaModel$BooleanRef$;
import com.mpc.scalats.core.ScalaModel$DateRef$;
import com.mpc.scalats.core.ScalaModel$DateTimeRef$;
import com.mpc.scalats.core.ScalaModel$DoubleRef$;
import com.mpc.scalats.core.ScalaModel$IntRef$;
import com.mpc.scalats.core.ScalaModel$LongRef$;
import com.mpc.scalats.core.ScalaModel$StringRef$;
import com.mpc.scalats.core.ScalaModel$StructRef$;
import com.mpc.scalats.core.TypeScriptModel;
import com.mpc.scalats.core.TypeScriptModel$BooleanRef$;
import com.mpc.scalats.core.TypeScriptModel$DateRef$;
import com.mpc.scalats.core.TypeScriptModel$DateTimeRef$;
import com.mpc.scalats.core.TypeScriptModel$NullRef$;
import com.mpc.scalats.core.TypeScriptModel$NumberRef$;
import com.mpc.scalats.core.TypeScriptModel$ObjectRef$;
import com.mpc.scalats.core.TypeScriptModel$StringRef$;
import com.mpc.scalats.core.TypeScriptModel$UndefinedRef$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class Compiler$ {
    public static Compiler$ MODULE$;

    static {
        new Compiler$();
    }

    public List<TypeScriptModel.Declaration> compile(List<ScalaModel.Entity> scalaEntities, Config config) {
        return scalaEntities.map((Function1<ScalaModel.Entity, TypeScriptModel.Declaration> & Serializable & scala.Serializable)scalaEntity -> MODULE$.compileEntity((ScalaModel.Entity)scalaEntity, config), List$.MODULE$.canBuildFrom());
    }

    private TypeScriptModel.Declaration compileEntity(ScalaModel.Entity entity, Config config) {
        ScalaModel.Entity entity2 = entity;
        if (entity2 instanceof ScalaModel.ClassEntity) {
            ScalaModel.ClassEntity classEntity = (ScalaModel.ClassEntity)entity2;
            return new TypeScriptModel.InterfaceDeclaration(classEntity.name(), classEntity.members().map((Function1<ScalaModel.EntityMember, TypeScriptModel.Member> & Serializable & scala.Serializable)scalaMember -> new TypeScriptModel.Member(scalaMember.name(), MODULE$.compileTypeRef(scalaMember.typeRef(), config)), List$.MODULE$.canBuildFrom()), classEntity.params());
        }
        if (entity2 instanceof ScalaModel.ObjectEntity) {
            ScalaModel.ObjectEntity objectEntity = (ScalaModel.ObjectEntity)entity2;
            return new TypeScriptModel.ConstantDeclaration(new TypeScriptModel.Member(objectEntity.name(), TypeScriptModel$ObjectRef$.MODULE$), new TypeScriptModel.ObjectValue(objectEntity.members().map((Function1<ScalaModel.EntityMember, Tuple2> & Serializable & scala.Serializable)scalaMember -> MODULE$.compileMember((ScalaModel.EntityMember)scalaMember, config), List$.MODULE$.canBuildFrom())));
        }
        throw new MatchError(entity2);
    }

    private Tuple2<TypeScriptModel.Member, TypeScriptModel.Value> compileMember(ScalaModel.EntityMember scalaMember2, Config config) {
        scala.Serializable serializable;
        TypeScriptModel.Member member = new TypeScriptModel.Member(scalaMember2.name(), this.compileTypeRef(scalaMember2.typeRef(), config));
        ScalaModel.Value value = scalaMember2.valueOpt().get();
        if (value instanceof ScalaModel.SimpleValue) {
            ScalaModel.SimpleValue simpleValue = (ScalaModel.SimpleValue)value;
            serializable = new TypeScriptModel.PrimitiveValue(simpleValue.value(), this.compileTypeRef(simpleValue.typeRef(), config));
        } else if (value instanceof ScalaModel.StructValue) {
            ScalaModel.StructValue structValue = (ScalaModel.StructValue)value;
            serializable = new TypeScriptModel.ObjectValue(((TraversableOnce)structValue.members().map((Function1<ScalaModel.EntityMember, Tuple2> & Serializable & scala.Serializable)scalaMember -> MODULE$.compileMember((ScalaModel.EntityMember)scalaMember, config), Seq$.MODULE$.canBuildFrom())).toList());
        } else {
            throw new MatchError(value);
        }
        scala.Serializable value2 = serializable;
        return new Tuple2<TypeScriptModel.Member, TypeScriptModel.Value>(member, (TypeScriptModel.Value)((Object)value2));
    }

    private TypeScriptModel.TypeRef compileTypeRef(ScalaModel.TypeRef scalaTypeRef, Config config) {
        boolean bl = false;
        ScalaModel.OptionRef optionRef = null;
        ScalaModel.TypeRef typeRef = scalaTypeRef;
        if (ScalaModel$IntRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$NumberRef$.MODULE$;
        }
        if (ScalaModel$LongRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$NumberRef$.MODULE$;
        }
        if (ScalaModel$DoubleRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$NumberRef$.MODULE$;
        }
        if (ScalaModel$BooleanRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$BooleanRef$.MODULE$;
        }
        if (ScalaModel$StringRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$StringRef$.MODULE$;
        }
        if (typeRef instanceof ScalaModel.SeqRef) {
            ScalaModel.SeqRef seqRef = (ScalaModel.SeqRef)typeRef;
            ScalaModel.TypeRef innerType = seqRef.innerType();
            return new TypeScriptModel.ArrayRef(this.compileTypeRef(innerType, config));
        }
        if (typeRef instanceof ScalaModel.CaseClassRef) {
            ScalaModel.CaseClassRef caseClassRef = (ScalaModel.CaseClassRef)typeRef;
            String name = caseClassRef.name();
            List<ScalaModel.TypeRef> typeArgs = caseClassRef.typeArgs();
            return new TypeScriptModel.CustomTypeRef(name, typeArgs.map((Function1<ScalaModel.TypeRef, TypeScriptModel.TypeRef> & Serializable & scala.Serializable)x$1 -> MODULE$.compileTypeRef((ScalaModel.TypeRef)x$1, config), List$.MODULE$.canBuildFrom()));
        }
        if (ScalaModel$DateRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$DateRef$.MODULE$;
        }
        if (ScalaModel$DateTimeRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$DateTimeRef$.MODULE$;
        }
        if (typeRef instanceof ScalaModel.TypeParamRef) {
            ScalaModel.TypeParamRef typeParamRef = (ScalaModel.TypeParamRef)typeRef;
            String name = typeParamRef.name();
            return new TypeScriptModel.TypeParamRef(name);
        }
        if (typeRef instanceof ScalaModel.OptionRef) {
            bl = true;
            optionRef = (ScalaModel.OptionRef)typeRef;
            ScalaModel.TypeRef innerType = optionRef.innerType();
            if (config.optionToNullable() && config.optionToUndefined()) {
                return new TypeScriptModel.UnionType(new TypeScriptModel.UnionType(this.compileTypeRef(innerType, config), TypeScriptModel$NullRef$.MODULE$), TypeScriptModel$UndefinedRef$.MODULE$);
            }
        }
        if (bl) {
            ScalaModel.TypeRef innerType = optionRef.innerType();
            if (config.optionToNullable()) {
                return new TypeScriptModel.UnionType(this.compileTypeRef(innerType, config), TypeScriptModel$NullRef$.MODULE$);
            }
        }
        if (typeRef instanceof ScalaModel.MapRef) {
            ScalaModel.MapRef mapRef = (ScalaModel.MapRef)typeRef;
            ScalaModel.TypeRef kT = mapRef.keyType();
            ScalaModel.TypeRef vT = mapRef.valueType();
            return new TypeScriptModel.MapType(this.compileTypeRef(kT, config), this.compileTypeRef(vT, config));
        }
        if (typeRef instanceof ScalaModel.UnionRef) {
            ScalaModel.UnionRef unionRef = (ScalaModel.UnionRef)typeRef;
            ScalaModel.TypeRef i = unionRef.innerType();
            ScalaModel.TypeRef i2 = unionRef.innerType2();
            return new TypeScriptModel.UnionType(this.compileTypeRef(i, config), this.compileTypeRef(i2, config));
        }
        if (bl) {
            ScalaModel.TypeRef innerType = optionRef.innerType();
            if (config.optionToUndefined()) {
                return new TypeScriptModel.UnionType(this.compileTypeRef(innerType, config), TypeScriptModel$UndefinedRef$.MODULE$);
            }
        }
        if (ScalaModel$StructRef$.MODULE$.equals(typeRef)) {
            return TypeScriptModel$ObjectRef$.MODULE$;
        }
        if (typeRef instanceof ScalaModel.UnknownTypeRef) {
            return TypeScriptModel$StringRef$.MODULE$;
        }
        throw new MatchError(typeRef);
    }

    private Compiler$() {
        MODULE$ = this;
    }
}

