/*
 * Decompiled with CFR 0.152.
 */
package com.mpc.scalats.core;

import com.mpc.scalats.configuration.Config;
import com.mpc.scalats.core.TypeScriptModel;
import com.mpc.scalats.core.TypeScriptModel$AccessModifier$Private$;
import com.mpc.scalats.core.TypeScriptModel$AccessModifier$Public$;
import com.mpc.scalats.core.TypeScriptModel$BooleanRef$;
import com.mpc.scalats.core.TypeScriptModel$DateRef$;
import com.mpc.scalats.core.TypeScriptModel$DateTimeRef$;
import com.mpc.scalats.core.TypeScriptModel$NullRef$;
import com.mpc.scalats.core.TypeScriptModel$NumberRef$;
import com.mpc.scalats.core.TypeScriptModel$ObjectRef$;
import com.mpc.scalats.core.TypeScriptModel$StringRef$;
import com.mpc.scalats.core.TypeScriptModel$UndefinedRef$;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class TypeScriptEmitter$ {
    public static TypeScriptEmitter$ MODULE$;

    static {
        new TypeScriptEmitter$();
    }

    public void emit(List<TypeScriptModel.Declaration> declaration, PrintStream out, Config config) {
        declaration.foreach((Function1<TypeScriptModel.Declaration, Object> & Serializable & scala.Serializable)x0$1 -> {
            TypeScriptEmitter$.$anonfun$emit$1(out, config, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void emitConstant(TypeScriptModel.ConstantDeclaration decl, PrintStream out) {
        TypeScriptModel.Value value;
        TypeScriptModel.Member member;
        block3: {
            TypeScriptModel.ConstantDeclaration constantDeclaration;
            block2: {
                constantDeclaration = decl;
                if (constantDeclaration == null) break block2;
                member = constantDeclaration.member();
                value = constantDeclaration.value();
                if (member != null) break block3;
            }
            throw new MatchError(constantDeclaration);
        }
        String name = member.name();
        TypeScriptModel.TypeRef typeRef = member.typeRef();
        Tuple3<String, TypeScriptModel.TypeRef, TypeScriptModel.Value> tuple3 = new Tuple3<String, TypeScriptModel.TypeRef, TypeScriptModel.Value>(name, typeRef, value);
        String name2 = tuple3._1();
        TypeScriptModel.TypeRef typeRef2 = tuple3._2();
        TypeScriptModel.Value value2 = tuple3._3();
        TypeScriptModel.TypeRef typeRef3 = typeRef2;
        TypeScriptModel.TypeRef typeRef4 = value2.typeRef();
        Predef$.MODULE$.assume(!(typeRef3 != null ? !typeRef3.equals(typeRef4) : typeRef4 != null));
        out.println(new java.lang.StringBuilder(19).append("export const ").append(name2).append(": ").append(this.getTypeRefString(typeRef2)).append(" = ").append(this.emitValue(value2, 0)).append(";").toString());
        out.println();
    }

    private String emitValue(TypeScriptModel.Value value, int indent) {
        boolean bl = false;
        TypeScriptModel.PrimitiveValue primitiveValue = null;
        TypeScriptModel.Value value2 = value;
        if (value2 instanceof TypeScriptModel.PrimitiveValue) {
            bl = true;
            primitiveValue = (TypeScriptModel.PrimitiveValue)value2;
            Object object = primitiveValue.value();
            TypeScriptModel.TypeRef typeRef = primitiveValue.typeRef();
            if (object == null && TypeScriptModel$NullRef$.MODULE$.equals(typeRef)) {
                return "null";
            }
        }
        if (bl) {
            Object object = primitiveValue.value();
            TypeScriptModel.TypeRef typeRef = primitiveValue.typeRef();
            if (object == null && TypeScriptModel$UndefinedRef$.MODULE$.equals(typeRef)) {
                return "undefined";
            }
        }
        if (bl) {
            Object v = primitiveValue.value();
            TypeScriptModel.TypeRef typeRef = primitiveValue.typeRef();
            if (TypeScriptModel$StringRef$.MODULE$.equals(typeRef)) {
                return new java.lang.StringBuilder(2).append("\"").append(v).append("\"").toString();
            }
        }
        if (bl) {
            Object date = primitiveValue.value();
            TypeScriptModel.TypeRef typeRef = primitiveValue.typeRef();
            if (date instanceof Date) {
                Date date2 = (Date)date;
                if (TypeScriptModel$DateRef$.MODULE$.equals(typeRef)) {
                    return new java.lang.StringBuilder(10).append("new Date(").append(date2.getTime()).append(")").toString();
                }
            }
        }
        if (bl) {
            Object millis = primitiveValue.value();
            TypeScriptModel.TypeRef typeRef = primitiveValue.typeRef();
            if (millis instanceof Number) {
                Number number = (Number)millis;
                if (TypeScriptModel$DateRef$.MODULE$.equals(typeRef)) {
                    return new java.lang.StringBuilder(10).append("new Date(").append(number).append(")").toString();
                }
            }
        }
        if (bl) {
            Object v = primitiveValue.value();
            return v.toString();
        }
        if (value2 instanceof TypeScriptModel.ObjectValue) {
            TypeScriptModel.ObjectValue objectValue = (TypeScriptModel.ObjectValue)value2;
            List<Tuple2<TypeScriptModel.Member, TypeScriptModel.Value>> members = objectValue.members();
            String tab = "  ";
            String margin = new StringOps(Predef$.MODULE$.augmentString(tab)).$times(indent);
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            members.zipWithIndex(List$.MODULE$.canBuildFrom()).foreach((Function1<Tuple2, StringBuilder> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        TypeScriptModel.Member member = (TypeScriptModel.Member)tuple22._1();
                        TypeScriptModel.Value memberValue = (TypeScriptModel.Value)tuple22._2();
                        sb.append(new java.lang.StringBuilder(2).append(margin).append(tab).append(member.name()).append(": ").append(MODULE$.emitValue(memberValue, indent + 1)).toString());
                        Serializable serializable = i < members.length() - 1 ? sb.append(",") : BoxedUnit.UNIT;
                        return sb.append("\n");
                    }
                }
                throw new MatchError(tuple2);
            });
            sb.append(new java.lang.StringBuilder(1).append(margin).append("}").toString());
            return sb.toString();
        }
        throw new MatchError(value2);
    }

    private void emitInterfaceDeclaration(TypeScriptModel.InterfaceDeclaration decl, PrintStream out, boolean emitAsType) {
        TypeScriptModel.InterfaceDeclaration interfaceDeclaration = decl;
        if (interfaceDeclaration == null) {
            throw new MatchError(interfaceDeclaration);
        }
        String name = interfaceDeclaration.name();
        List<TypeScriptModel.Member> members = interfaceDeclaration.members();
        List<String> typeParams = interfaceDeclaration.typeParams();
        Tuple3<String, List<TypeScriptModel.Member>, List<String>> tuple3 = new Tuple3<String, List<TypeScriptModel.Member>, List<String>>(name, members, typeParams);
        String name2 = tuple3._1();
        List<TypeScriptModel.Member> members2 = tuple3._2();
        List<String> typeParams2 = tuple3._3();
        out.print(emitAsType ? new java.lang.StringBuilder(14).append("export type ").append(name2).append(" =").toString() : new java.lang.StringBuilder(17).append("export interface ").append(name2).toString());
        this.emitTypeParams(decl.typeParams(), out);
        out.println(" {");
        members2.foreach((Function1<TypeScriptModel.Member, Object> & Serializable & scala.Serializable)member -> {
            TypeScriptEmitter$.$anonfun$emitInterfaceDeclaration$1(out, emitAsType, member);
            return BoxedUnit.UNIT;
        });
        out.println("}");
        out.println();
    }

    private void emitClassDeclaration(TypeScriptModel.ClassDeclaration decl, PrintStream out) {
        List<String> typeParams;
        TypeScriptModel.ClassConstructor classConstructor;
        String name;
        block3: {
            TypeScriptModel.ClassDeclaration classDeclaration;
            block2: {
                classDeclaration = decl;
                if (classDeclaration == null) break block2;
                name = classDeclaration.name();
                classConstructor = classDeclaration.constructor();
                typeParams = classDeclaration.typeParams();
                if (classConstructor != null) break block3;
            }
            throw new MatchError(classDeclaration);
        }
        List<TypeScriptModel.ClassConstructorParameter> parameters = classConstructor.parameters();
        Tuple3<String, List<TypeScriptModel.ClassConstructorParameter>, List<String>> tuple3 = new Tuple3<String, List<TypeScriptModel.ClassConstructorParameter>, List<String>>(name, parameters, typeParams);
        String name2 = tuple3._1();
        List<TypeScriptModel.ClassConstructorParameter> parameters2 = tuple3._2();
        List<String> typeParams2 = tuple3._3();
        out.print(new java.lang.StringBuilder(13).append("export class ").append(name2).toString());
        this.emitTypeParams(decl.typeParams(), out);
        out.println(" {");
        out.println("\tconstructor(");
        parameters2.zipWithIndex(List$.MODULE$.canBuildFrom()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            TypeScriptEmitter$.$anonfun$emitClassDeclaration$1(out, parameters2, x0$1);
            return BoxedUnit.UNIT;
        });
        out.println("\t) {}");
        out.println("}");
    }

    private void emitTypeParams(List<String> params, PrintStream out) {
        if (params.nonEmpty()) {
            out.print("<");
            out.print(params.mkString(", "));
            out.print(">");
            return;
        }
    }

    private String getTypeRefString(TypeScriptModel.TypeRef typeRef2) {
        boolean bl = false;
        TypeScriptModel.CustomTypeRef customTypeRef = null;
        TypeScriptModel.TypeRef typeRef3 = typeRef2;
        if (TypeScriptModel$NumberRef$.MODULE$.equals(typeRef3)) {
            return "number";
        }
        if (TypeScriptModel$BooleanRef$.MODULE$.equals(typeRef3)) {
            return "boolean";
        }
        if (TypeScriptModel$StringRef$.MODULE$.equals(typeRef3)) {
            return "string";
        }
        if (TypeScriptModel$DateRef$.MODULE$.equals(typeRef3) ? true : TypeScriptModel$DateTimeRef$.MODULE$.equals(typeRef3)) {
            return "Date";
        }
        if (TypeScriptModel$ObjectRef$.MODULE$.equals(typeRef3) ? true : TypeScriptModel$DateTimeRef$.MODULE$.equals(typeRef3)) {
            return "object";
        }
        if (typeRef3 instanceof TypeScriptModel.ArrayRef) {
            TypeScriptModel.ArrayRef arrayRef = (TypeScriptModel.ArrayRef)typeRef3;
            TypeScriptModel.TypeRef innerType = arrayRef.innerType();
            return new java.lang.StringBuilder(2).append(this.getTypeRefString(innerType)).append("[]").toString();
        }
        if (typeRef3 instanceof TypeScriptModel.CustomTypeRef) {
            bl = true;
            customTypeRef = (TypeScriptModel.CustomTypeRef)typeRef3;
            String name = customTypeRef.name();
            List<TypeScriptModel.TypeRef> params = customTypeRef.typeArgs();
            if (params.isEmpty()) {
                return name;
            }
        }
        if (bl) {
            String name = customTypeRef.name();
            List<TypeScriptModel.TypeRef> params = customTypeRef.typeArgs();
            if (params.nonEmpty()) {
                return new java.lang.StringBuilder(2).append(name).append("<").append(((TraversableOnce)params.map((Function1<TypeScriptModel.TypeRef, String> & Serializable & scala.Serializable)typeRef -> MODULE$.getTypeRefString((TypeScriptModel.TypeRef)typeRef), List$.MODULE$.canBuildFrom())).mkString(", ")).append(">").toString();
            }
        }
        if (typeRef3 instanceof TypeScriptModel.UnknownTypeRef) {
            TypeScriptModel.UnknownTypeRef unknownTypeRef = (TypeScriptModel.UnknownTypeRef)typeRef3;
            String typeName = unknownTypeRef.name();
            return typeName;
        }
        if (typeRef3 instanceof TypeScriptModel.TypeParamRef) {
            TypeScriptModel.TypeParamRef typeParamRef = (TypeScriptModel.TypeParamRef)typeRef3;
            String param2 = typeParamRef.name();
            return param2;
        }
        if (typeRef3 instanceof TypeScriptModel.UnionType) {
            TypeScriptModel.UnionType unionType = (TypeScriptModel.UnionType)typeRef3;
            TypeScriptModel.TypeRef inner1 = unionType.inner1();
            TypeScriptModel.TypeRef inner2 = unionType.inner2();
            return new java.lang.StringBuilder(5).append("(").append(this.getTypeRefString(inner1)).append(" | ").append(this.getTypeRefString(inner2)).append(")").toString();
        }
        if (typeRef3 instanceof TypeScriptModel.MapType) {
            TypeScriptModel.MapType mapType = (TypeScriptModel.MapType)typeRef3;
            TypeScriptModel.TypeRef keyType = mapType.keyType();
            TypeScriptModel.TypeRef valueType = mapType.valueType();
            return new java.lang.StringBuilder(13).append("{ [key: ").append(this.getTypeRefString(keyType)).append("]: ").append(this.getTypeRefString(valueType)).append(" }").toString();
        }
        if (TypeScriptModel$NullRef$.MODULE$.equals(typeRef3)) {
            return "null";
        }
        if (TypeScriptModel$UndefinedRef$.MODULE$.equals(typeRef3)) {
            return "undefined";
        }
        throw new MatchError(typeRef3);
    }

    public static final /* synthetic */ void $anonfun$emit$1(PrintStream out$1, Config config$1, TypeScriptModel.Declaration x0$1) {
        TypeScriptModel.Declaration declaration = x0$1;
        if (declaration instanceof TypeScriptModel.InterfaceDeclaration) {
            TypeScriptModel.InterfaceDeclaration interfaceDeclaration = (TypeScriptModel.InterfaceDeclaration)declaration;
            MODULE$.emitInterfaceDeclaration(interfaceDeclaration, out$1, config$1.emitInterfacesAsTypes());
            return;
        }
        if (declaration instanceof TypeScriptModel.ClassDeclaration) {
            TypeScriptModel.ClassDeclaration classDeclaration = (TypeScriptModel.ClassDeclaration)declaration;
            MODULE$.emitClassDeclaration(classDeclaration, out$1);
            return;
        }
        if (declaration instanceof TypeScriptModel.ConstantDeclaration) {
            TypeScriptModel.ConstantDeclaration constantDeclaration = (TypeScriptModel.ConstantDeclaration)declaration;
            MODULE$.emitConstant(constantDeclaration, out$1);
            return;
        }
        throw new MatchError(declaration);
    }

    public static final /* synthetic */ void $anonfun$emitInterfaceDeclaration$1(PrintStream out$2, boolean emitAsType$1, TypeScriptModel.Member member) {
        out$2.print(new java.lang.StringBuilder(4).append("  ").append(member.name()).append(": ").append(MODULE$.getTypeRefString(member.typeRef())).toString());
        out$2.println(emitAsType$1 ? "," : ";");
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$emitClassDeclaration$1(PrintStream out$3, List parameters$1, Tuple2 x0$1) {
        block6: {
            var5_3 = x0$1;
            if (var5_3 == null) break block6;
            parameter = (TypeScriptModel.ClassConstructorParameter)var5_3._1();
            index = var5_3._2$mcI$sp();
            var9_6 = false;
            var10_7 = null;
            var11_8 = parameter.accessModifier();
            if (!(var11_8 instanceof Some)) ** GOTO lbl-1000
            var9_6 = true;
            var10_7 = (Some)var11_8;
            var12_9 = (TypeScriptModel.AccessModifier)var10_7.value();
            if (TypeScriptModel$AccessModifier$Public$.MODULE$.equals(var12_9)) {
                v0 = "public ";
            } else if (var9_6 && TypeScriptModel$AccessModifier$Private$.MODULE$.equals(var13_10 = (TypeScriptModel.AccessModifier)var10_7.value())) {
                v0 = "private ";
            } else if (None$.MODULE$.equals(var11_8)) {
                v0 = "";
            } else {
                throw new MatchError(var11_8);
            }
            accessModifier = v0;
            out$3.print(new java.lang.StringBuilder(4).append("\t\t").append(accessModifier).append(parameter.name()).append(": ").append(TypeScriptEmitter$.MODULE$.getTypeRefString(parameter.typeRef())).toString());
            endLine = index + 1 < parameters$1.length() ? "," : "";
            out$3.println(endLine);
            return;
        }
        throw new MatchError(var5_3);
    }

    private TypeScriptEmitter$() {
        MODULE$ = this;
    }
}

