/*
 * Decompiled with CFR 0.152.
 */
package wrm.libsass;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import java.io.File;
import java.net.URI;

public class SassCompiler {
    private String includePaths;
    private io.bit3.jsass.OutputStyle outputStyle;
    private boolean generateSourceComments;
    private boolean generateSourceMap;
    private boolean omitSourceMappingURL;
    private boolean embedSourceMapInCSS;
    private boolean embedSourceContentsInSourceMap;
    private InputSyntax inputSyntax;
    private int precision;

    public Output compileFile(String inputPathAbsolute, String outputPathRelativeToInput, String sourceMapPathRelativeToInput) throws CompilationException {
        String inputOmitSpace = inputPathAbsolute.replaceAll("%20", " ");
        String outputOmitSpace = outputPathRelativeToInput.replaceAll("%20", " ");
        URI inputFile = new File(inputOmitSpace).toURI();
        URI outputFile = new File(outputOmitSpace).toURI();
        Options opt = this.getConfiguredOptions(inputPathAbsolute, sourceMapPathRelativeToInput);
        Compiler c = new Compiler();
        return c.compileFile(inputFile, outputFile, opt);
    }

    private Options getConfiguredOptions(String inputPathAbsolute, String sourceMapPathRelativeToInput) {
        Options opt = new Options();
        if (this.includePaths != null) {
            for (String path : this.includePaths.split(File.pathSeparator)) {
                opt.getIncludePaths().add(new File(path));
            }
        }
        String allIncludePaths = new File(inputPathAbsolute).getParent();
        opt.getIncludePaths().add(new File(allIncludePaths));
        opt.setIsIndentedSyntaxSrc(this.inputSyntax == InputSyntax.sass);
        opt.setOutputStyle(this.outputStyle);
        opt.setSourceComments(this.generateSourceComments);
        opt.setPrecision(this.precision);
        if (this.generateSourceMap) {
            opt.setSourceMapFile(new File(sourceMapPathRelativeToInput).toURI());
            opt.setSourceMapContents(this.embedSourceContentsInSourceMap);
            opt.setSourceMapEmbed(this.embedSourceMapInCSS);
            opt.setOmitSourceMapUrl(this.omitSourceMappingURL);
        } else {
            opt.setSourceMapContents(false);
            opt.setSourceMapEmbed(false);
            opt.setOmitSourceMapUrl(true);
        }
        return opt;
    }

    public void setEmbedSourceMapInCSS(boolean embedSourceMapInCSS) {
        this.embedSourceMapInCSS = embedSourceMapInCSS;
    }

    public void setEmbedSourceContentsInSourceMap(boolean embedSourceContentsInSourceMap) {
        this.embedSourceContentsInSourceMap = embedSourceContentsInSourceMap;
    }

    public void setGenerateSourceComments(boolean generateSourceComments) {
        this.generateSourceComments = generateSourceComments;
    }

    public void setGenerateSourceMap(boolean generateSourceMap) {
        this.generateSourceMap = generateSourceMap;
    }

    public void setIncludePaths(String includePaths) {
        this.includePaths = includePaths;
    }

    public void setInputSyntax(InputSyntax inputSyntax) {
        this.inputSyntax = inputSyntax;
    }

    public void setOmitSourceMappingURL(boolean omitSourceMappingURL) {
        this.omitSourceMappingURL = omitSourceMappingURL;
    }

    public void setOutputStyle(io.bit3.jsass.OutputStyle outputStyle) {
        this.outputStyle = outputStyle;
    }

    public void setOutputStyle(OutputStyle outputStyle) {
        this.outputStyle = io.bit3.jsass.OutputStyle.values()[outputStyle.ordinal()];
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public static enum InputSyntax {
        sass,
        scss;

    }

    public static enum OutputStyle {
        nested,
        expanded,
        compact,
        compressed;

    }
}

