/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.ComparableVersion;
import com.google.gson.GsonBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class Driver {
    private String name;
    private String platform;
    private String bit;
    private String version;
    private String url;
    private String fileMatchInside;
    private String customFileName;

    public String getId() {
        if (this.customFileName != null && !this.customFileName.isEmpty()) {
            return this.customFileName;
        }
        return this.name + (this.platform != null ? "-" + this.platform : "") + (this.bit != null ? "-" + this.bit + "bit" : "");
    }

    public String getDriverDownloadDirectoryName() {
        return this.name + (this.platform != null ? "-" + this.platform : "") + (this.bit != null ? "-" + this.bit + "bit" : "") + (this.version != null ? "-" + this.version : "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getCustomFileName() {
        return this.customFileName;
    }

    public void setCustomFileName(String customFileName) {
        this.customFileName = customFileName;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getBit() {
        return this.bit;
    }

    public void setBit(String bit) {
        this.bit = bit;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ComparableVersion getComparableVersion() {
        return new ComparableVersion(this.version);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFileName() {
        if ("windows".equalsIgnoreCase(this.platform)) {
            return this.getId() + ".exe";
        }
        return this.getId();
    }

    public String getFilenameFromUrl() {
        try {
            String file = new URL(this.url).getFile();
            return file.replaceAll(".*\\/", "");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public String getFileMatchInside() {
        return this.fileMatchInside;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

