/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojo;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;

public class DriverDownloader {
    public static final int FILE_DOWNLOAD_READ_TIMEOUT = 1800000;
    public static final int FILE_DOWNLOAD_CONNECT_TIMEOUT = 30000;
    public static final int FILE_DOWNLOAD_RETRY_ATTEMPTS = 3;
    private final InstallDriversMojo mojo;
    private final Proxy proxySettings;

    public DriverDownloader(InstallDriversMojo mojo) throws MojoExecutionException {
        this.mojo = mojo;
        this.proxySettings = ProxyUtils.getProxyFromSettings(mojo);
    }

    public Path downloadFile(Driver driver, Path downloadDirectory) throws MojoExecutionException {
        String url = driver.getUrl();
        Path downloadFilePath = downloadDirectory.resolve(driver.getFilenameFromUrl());
        if (downloadFilePath.toFile().exists() && !this.downloadCompletedFileExists(downloadDirectory)) {
            this.mojo.getLog().info((CharSequence)("  Removing downloaded driver " + Utils.quote(downloadFilePath) + " since it may be corrupt"));
            this.cleanupDriverDownloadDirectory(downloadDirectory);
        } else if (!this.mojo.keepDownloadedWebdrivers) {
            this.cleanupDriverDownloadDirectory(downloadDirectory);
        }
        if (downloadFilePath.toFile().exists()) {
            this.mojo.getLog().info((CharSequence)("  Using cached driver from " + Utils.quote(downloadFilePath)));
        } else {
            this.mojo.getLog().info((CharSequence)("  Downloading " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath)));
            HttpClientBuilder httpClientBuilder = this.prepareHttpClientBuilderWithTimeoutsAndProxySettings(this.proxySettings);
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true));
            try (CloseableHttpClient httpClient = httpClientBuilder.build();
                 CloseableHttpResponse fileDownloadResponse = httpClient.execute((HttpUriRequest)new HttpGet(url));){
                HttpEntity remoteFileStream = fileDownloadResponse.getEntity();
                FileUtils.copyInputStreamToFile((InputStream)remoteFileStream.getContent(), (File)downloadFilePath.toFile());
                if (this.driverFileIsCorrupt(downloadFilePath)) {
                    this.printXmlFileContentIfPresentInDownloadedFile(downloadFilePath);
                    this.cleanupDriverDownloadDirectory(downloadDirectory);
                    throw new InstallDriversMojoExecutionException("Failed to download a non corrupt driver", this.mojo, driver);
                }
            }
            catch (InstallDriversMojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InstallDriversMojoExecutionException("Failed to download driver from " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath) + " cause of " + e.getCause(), e, this.mojo, driver);
            }
            this.createDownloadCompletedFile(downloadDirectory);
        }
        return downloadFilePath;
    }

    private void printXmlFileContentIfPresentInDownloadedFile(Path downloadFilePath) {
        try {
            List<String> fileContent = Files.readAllLines(downloadFilePath, StandardCharsets.UTF_8);
            if (fileContent.get(0).startsWith("<?xml")) {
                this.mojo.getLog().info((CharSequence)"  Downloaded driver file contains the following error message");
                for (String line : fileContent) {
                    this.mojo.getLog().info((CharSequence)("  " + line));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HttpClientBuilder prepareHttpClientBuilderWithTimeoutsAndProxySettings(Proxy proxySettings) throws MojoExecutionException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(1800000).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setCookieSpec("ignoreCookies").build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig).disableContentCompression();
        HttpHost proxy = ProxyUtils.createProxyFromSettings(proxySettings);
        if (proxy != null) {
            httpClientBuilder.setProxy(proxy);
            CredentialsProvider proxyCredentials = ProxyUtils.createProxyCredentialsFromSettings(proxySettings);
            if (proxyCredentials != null) {
                httpClientBuilder.setDefaultCredentialsProvider(proxyCredentials);
            }
        }
        return httpClientBuilder;
    }

    private boolean driverFileIsCorrupt(Path downloadFilePath) {
        if (Utils.hasExtension(downloadFilePath, "zip")) {
            return !Utils.validateZipFile(downloadFilePath);
        }
        if (Utils.hasExtension(downloadFilePath, "bz2")) {
            if (!Utils.validateBz2File(downloadFilePath)) {
                return true;
            }
            return !Utils.validateFileIsLargerThanBytes(downloadFilePath, 1000);
        }
        return false;
    }

    public void cleanupDriverDownloadDirectory(Path downloadDirectory) throws MojoExecutionException {
        try {
            FileUtils.deleteDirectory((File)downloadDirectory.toFile());
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to delete driver cache directory:" + System.lineSeparator() + Utils.directoryToString(downloadDirectory), e);
        }
    }

    private boolean downloadCompletedFileExists(Path downloadDirectory) {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        return downloadCompletedFile.toFile().exists();
    }

    private void createDownloadCompletedFile(Path downloadDirectory) throws InstallDriversMojoExecutionException {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        try {
            Files.createFile(downloadCompletedFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to create download.completed file at " + downloadCompletedFile, e);
        }
    }
}

