/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverVersionHandler;
import com.github.webdriverextensions.InstallDriversMojo;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public class DriverInstaller {
    private final InstallDriversMojo mojo;
    private final DriverVersionHandler versionHandler;

    public DriverInstaller(InstallDriversMojo mojo) {
        this.mojo = mojo;
        this.versionHandler = new DriverVersionHandler(mojo.installationDirectory.toPath());
    }

    public boolean needInstallation(Driver driver) throws MojoExecutionException {
        return !this.isInstalled(driver) || !this.versionHandler.isSameVersion(driver);
    }

    public void install(Driver driver, Path extractLocation) throws MojoExecutionException {
        this.mojo.getLog().info((CharSequence)("start installing : " + driver.getName() + " from " + extractLocation));
        if (extractLocation.toFile().isDirectory() && this.directoryIsEmpty(extractLocation)) {
            throw new InstallDriversMojoExecutionException("Failed to install driver since no files found to install", this.mojo, driver);
        }
        try {
            Files.createDirectories(this.mojo.installationDirectory.toPath(), new FileAttribute[0]);
            if (this.directoryContainsSingleDirectory(extractLocation)) {
                Path singleDirectory = extractLocation.toFile().listFiles()[0].toPath();
                this.moveAllFilesInDirectory(singleDirectory, this.mojo.installationDirectory.toPath().resolve(driver.getId()));
            } else if (this.directoryContainsSingleFile(extractLocation)) {
                String newFileName = driver.getFileName();
                this.moveFileInDirectory(extractLocation, this.mojo.installationDirectory.toPath(), newFileName);
                this.makeExecutable(this.mojo.installationDirectory.toPath().resolve(newFileName));
            } else {
                this.moveAllFilesInDirectory(extractLocation, this.mojo.installationDirectory.toPath().resolve(driver.getId()));
            }
            this.versionHandler.writeVersionFile(driver);
        }
        catch (Exception e) {
            throw new InstallDriversMojoExecutionException("Failed to install driver cause of " + e.getMessage(), e, this.mojo, driver);
        }
    }

    private boolean isInstalled(Driver driver) {
        Path path = this.mojo.installationDirectory.toPath().resolve(driver.getFileName());
        return path.toFile().exists();
    }

    private boolean directoryIsEmpty(Path directory) {
        return directory.toFile().listFiles().length == 0;
    }

    private boolean directoryContainsSingleFile(Path directory) throws MojoExecutionException {
        File[] files = directory.toFile().listFiles();
        return files != null && files.length == 1 && files[0].isFile();
    }

    private boolean directoryContainsSingleDirectory(Path directory) {
        File[] files = directory.toFile().listFiles();
        return files != null && files.length == 1 && files[0].isDirectory();
    }

    private void moveFileInDirectory(Path from, Path to, String newFileName) throws MojoExecutionException {
        assert (this.directoryContainsSingleFile(from));
        try {
            List files = FileUtils.getFileNames((File)from.toFile(), null, null, (boolean)true);
            Path singleFile = Paths.get((String)files.get(0), new String[0]);
            this.mojo.getLog().info((CharSequence)("  Moving (one File) " + Utils.quote(singleFile) + " to " + Utils.quote(to.resolve(newFileName))));
            FileUtils.forceDelete((File)to.resolve(newFileName).toFile());
            Files.move(singleFile, to.resolve(newFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to move file in directory " + Utils.quote(from) + " to " + Utils.quote(to.resolve(newFileName)), e);
        }
    }

    private void moveAllFilesInDirectory(Path from, Path to) throws MojoExecutionException {
        try {
            Files.createDirectories(to, new FileAttribute[0]);
            for (File file : from.toFile().listFiles()) {
                this.mojo.getLog().info((CharSequence)("  Moving (All Files) " + file + " to " + to.resolve(file.toPath().getFileName())));
                FileUtils.forceDelete((File)to.resolve(file.toPath().getFileName()).toFile());
                Files.move(file.toPath(), to.resolve(file.toPath().getFileName()), new CopyOption[0]);
                this.makeExecutable(to.resolve(file.toPath().getFileName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to move directory " + Utils.quote(from) + " to " + Utils.quote(to), e);
        }
    }

    private void makeExecutable(Path path) {
        File file = path.toFile();
        if (file.exists() && !file.canExecute()) {
            file.setExecutable(true);
        }
    }
}

