/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

class DriverVersionHandler {
    private final Path installationDirectory;

    public DriverVersionHandler(Path installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    void writeVersionFile(Driver driver) throws MojoExecutionException {
        Path file = this.getVersionFile(driver);
        String versionString = this.createVersionString(driver);
        try {
            FileUtils.writeStringToFile((File)file.toFile(), (String)versionString);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create version file containing metadata about the installed driver" + Utils.debugInfo(driver), e);
        }
    }

    private String createVersionString(Driver driver) {
        return driver.toString();
    }

    private Path getVersionFile(Driver driver) {
        return this.installationDirectory.resolve(driver.getId() + ".version");
    }

    public boolean isSameVersion(Driver driver) throws MojoExecutionException {
        try {
            Path versionFile = this.getVersionFile(driver);
            if (!versionFile.toFile().exists()) {
                return false;
            }
            String savedVersion = FileUtils.readFileToString((File)versionFile.toFile());
            String currentVersion = this.createVersionString(driver);
            return savedVersion.equals(currentVersion);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to compare installed driver version with the driver version to install" + Utils.debugInfo(driver), e);
        }
    }
}

