/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverDownloader;
import com.github.webdriverextensions.DriverExtractor;
import com.github.webdriverextensions.DriverInstaller;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Repository;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

@Mojo(name="install-drivers", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class InstallDriversMojo
extends AbstractMojo {
    @Component
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    Settings settings;
    @Parameter(defaultValue="https://raw.githubusercontent.com/webdriverextensions/webdriverextensions-maven-plugin-repository/master/repository-3.0.json")
    URL repositoryUrl;
    @Parameter(defaultValue="${basedir}/drivers")
    File installationDirectory;
    @Parameter
    String proxyId;
    @Parameter
    List<Driver> drivers = new ArrayList<Driver>();
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="false")
    boolean keepDownloadedWebdrivers;
    Path pluginWorkingDirectory;
    Path downloadDirectory;
    Path tempDirectory;
    Repository repository;

    public InstallDriversMojo() {
        try {
            this.pluginWorkingDirectory = Files.createTempDirectory("webdriverextensions-maven-plugin", new FileAttribute[0]);
            this.downloadDirectory = this.pluginWorkingDirectory.resolve("downloads");
            this.tempDirectory = this.pluginWorkingDirectory.resolve("temp");
        }
        catch (IOException e) {
            throw new RuntimeException("error while creating folders", e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.settings.isOffline()) {
            this.getLog().info((CharSequence)"Skipping install-drivers goal execution (maven in offline mode)");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping install-drivers goal execution");
            return;
        }
        for (String property : new String[]{"skipTests", "skipITs", "maven.test.skip"}) {
            if (!Boolean.getBoolean(property)) continue;
            this.getLog().info((CharSequence)("Skipping install-drivers goal execution (" + property + ")"));
            return;
        }
        this.repository = Repository.load(this.repositoryUrl, ProxyUtils.getProxyFromSettings(this));
        this.getLog().info((CharSequence)("Installation directory " + Utils.quote(this.installationDirectory.toPath())));
        if (this.drivers.isEmpty()) {
            this.getLog().info((CharSequence)"Installing latest drivers for current platform");
            this.drivers = this.repository.getLatestDrivers();
        } else {
            this.getLog().info((CharSequence)"Installing drivers from configuration");
        }
        DriverDownloader driverDownloader = new DriverDownloader(this);
        DriverExtractor driverExtractor = new DriverExtractor(this);
        DriverInstaller driverInstaller = new DriverInstaller(this);
        this.cleanupTempDirectory();
        for (Driver _driver : this.drivers) {
            Driver driver = this.repository.enrichDriver(_driver);
            if (driver == null) continue;
            this.getLog().info((CharSequence)(driver.getId() + " version " + driver.getVersion()));
            if (driverInstaller.needInstallation(driver)) {
                Path downloadPath = this.downloadDirectory.resolve(driver.getDriverDownloadDirectoryName());
                Path downloadLocation = driverDownloader.downloadFile(driver, downloadPath);
                Path extractLocation = driverExtractor.extractDriver(driver, downloadLocation);
                driverInstaller.install(driver, extractLocation);
                if (!this.keepDownloadedWebdrivers) {
                    this.cleanupDownloadsDirectory();
                }
                this.cleanupTempDirectory();
                continue;
            }
            this.getLog().info((CharSequence)"  Already installed");
        }
    }

    private void cleanupDownloadsDirectory() throws MojoExecutionException {
        try {
            FileUtils.deleteDirectory((File)this.downloadDirectory.toFile());
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to delete downloads directory:" + System.lineSeparator() + Utils.directoryToString(this.downloadDirectory), e);
        }
    }

    private void cleanupTempDirectory() throws MojoExecutionException {
        try {
            FileUtils.deleteDirectory((File)this.tempDirectory.toFile());
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to delete temp directory:" + System.lineSeparator() + Utils.directoryToString(this.tempDirectory), e);
        }
    }
}

