/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.compare.ArgumentComparator;
import com.github.webdriverextensions.ComparableVersion;
import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class Repository {
    private List<Driver> drivers;

    Repository() {
    }

    static Repository load(URL repositoryUrl, Proxy proxySettings) throws MojoExecutionException {
        Repository repository;
        String repositoryAsString;
        try {
            repositoryAsString = Repository.downloadAsString(repositoryUrl, proxySettings);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to download repository from url " + Utils.quote(repositoryUrl), e);
        }
        try {
            repository = (Repository)new Gson().fromJson(repositoryAsString, Repository.class);
        }
        catch (JsonSyntaxException e) {
            throw new InstallDriversMojoExecutionException("Failed to parse repository json " + repositoryAsString, (Exception)((Object)e));
        }
        repository.drivers = Repository.sortDrivers(repository.drivers);
        return repository;
    }

    private static List<Driver> sortDrivers(List<Driver> drivers) {
        ArgumentComparator byId = new ArgumentComparator((Object)((Driver)Lambda.on(Driver.class)).getId());
        ArgumentComparator byVersion = new ArgumentComparator((Object)((Driver)Lambda.on(Driver.class)).getVersion());
        Comparator orderByIdAndVersion = ComparatorUtils.chainedComparator((Comparator)byId, (Comparator)byVersion);
        return Lambda.sort(drivers, (Object)Lambda.on(Driver.class), (Comparator)orderByIdAndVersion);
    }

    private static String downloadAsString(URL url, Proxy proxySettings) throws IOException {
        URLConnection connection;
        if (proxySettings != null) {
            java.net.Proxy proxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort()));
            if (proxySettings.getUsername() != null) {
                ProxyUtils.setProxyAuthenticator(proxySettings);
            }
            connection = url.openConnection(proxy);
        } else {
            connection = url.openConnection();
        }
        try (InputStream inputStream = connection.getInputStream();){
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
    }

    public List<Driver> getDrivers() {
        return this.drivers;
    }

    List<Driver> getDrivers(String name, String platform, String bit, String version) {
        List drivers = this.drivers;
        if (name != null) {
            drivers = Lambda.select(drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalToIgnoringCase((String)name))));
        }
        if (platform != null) {
            drivers = Lambda.select((Iterable)drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getPlatform(), (Matcher)Matchers.is((Matcher)Matchers.equalToIgnoringCase((String)platform))));
        }
        if (bit != null) {
            drivers = Lambda.select((Iterable)drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getBit(), (Matcher)Matchers.is((Matcher)Matchers.equalToIgnoringCase((String)bit))));
        }
        if (version != null) {
            drivers = Lambda.select((Iterable)drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getComparableVersion(), (Matcher)Matchers.is((Object)new ComparableVersion(version))));
        }
        return drivers;
    }

    Driver enrichDriver(Driver driver) throws MojoExecutionException {
        List<Driver> drivers;
        if (StringUtils.isBlank((CharSequence)driver.getName())) {
            throw new InstallDriversMojoExecutionException("Driver name must be set in configuration, driver: " + driver);
        }
        if (StringUtils.isNotBlank((CharSequence)driver.getUrl())) {
            return driver;
        }
        if ((StringUtils.isNotBlank((CharSequence)driver.getPlatform()) || StringUtils.isNotBlank((CharSequence)driver.getBit()) || StringUtils.isNotBlank((CharSequence)driver.getVersion())) && this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), driver.getVersion()).size() == 0) {
            throw new MojoExecutionException("Could not find driver: " + driver + System.lineSeparator() + System.lineSeparator() + "in repository: " + this);
        }
        if (StringUtils.isBlank((CharSequence)driver.getPlatform())) {
            driver.setPlatform(Repository.detectPlatform());
        }
        if (StringUtils.isBlank((CharSequence)driver.getBit())) {
            driver.setBit(Repository.detectBits(driver.getName()));
        }
        if (StringUtils.isBlank((CharSequence)driver.getVersion())) {
            driver.setVersion(this.getLatestDriverVersion(driver.getId()));
        }
        if ((drivers = this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), driver.getVersion())).isEmpty()) {
            if ("64".equals(driver.getBit())) {
                drivers = this.getDrivers(driver.getName(), driver.getPlatform(), "32", driver.getVersion());
                if (drivers.isEmpty()) {
                    return null;
                }
                return this.transferCustomFileName(driver, this.filterLatestDriver(drivers));
            }
            return null;
        }
        return this.transferCustomFileName(driver, drivers.get(0));
    }

    private Driver transferCustomFileName(Driver driver, Driver foundDriver) {
        if (StringUtils.isNotBlank((CharSequence)driver.getCustomFileName())) {
            foundDriver.setCustomFileName(driver.getCustomFileName());
        }
        return foundDriver;
    }

    List<Driver> getLatestDrivers() {
        ArrayList<Driver> latestDrivers = new ArrayList<Driver>();
        Collection driverNames = Lambda.selectDistinct((Iterable)Lambda.collect(this.drivers, (Object)((Driver)Lambda.on(Driver.class)).getName()));
        String platform = Repository.detectPlatform();
        for (String driverName : driverNames) {
            Driver latestDriverComplement;
            List driversWithDriverName = Lambda.select(this.drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getName(), (Matcher)Matchers.is((Object)driverName)));
            List driversWithDriverNameAndPlatform = Lambda.select((Iterable)driversWithDriverName, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getPlatform(), (Matcher)Matchers.is((Object)platform)));
            String bit = Repository.detectBits(driverName);
            boolean is64Bit = bit.equals("64");
            Driver latestDriver = this.getDriverByBit(bit, driversWithDriverNameAndPlatform);
            if (latestDriver != null) {
                latestDrivers.add(latestDriver);
                continue;
            }
            if (!is64Bit || (latestDriverComplement = this.getDriverByBit("32", driversWithDriverNameAndPlatform)) == null) continue;
            latestDrivers.add(latestDriverComplement);
        }
        return Repository.sortDrivers(latestDrivers);
    }

    private Driver getDriverByBit(String bit, List<Driver> driversWithDriverNameAndPlatform) {
        List driversWithDriverNameAndPlatformAndBit = Lambda.select(driversWithDriverNameAndPlatform, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getBit(), (Matcher)Matchers.is((Object)bit)));
        return (Driver)Lambda.selectMax((Object)driversWithDriverNameAndPlatformAndBit, (Object)((Driver)Lambda.on(Driver.class)).getComparableVersion());
    }

    private static String detectBits(String driverName) {
        if (driverName.equals("internetexplorerdriver") && !Utils.isWindows10()) {
            return "32";
        }
        if (Utils.is64Bit()) {
            return "64";
        }
        return "32";
    }

    private static String detectPlatform() {
        if (Utils.isMac()) {
            return "mac";
        }
        if (Utils.isLinux()) {
            return "linux";
        }
        return "windows";
    }

    private String getLatestDriverVersion(String driverId) {
        List allDriverVersions = Lambda.select(this.drivers, (Matcher)Lambda.having((Object)((Driver)Lambda.on(Driver.class)).getId(), (Matcher)Matchers.is((Object)driverId)));
        Driver latestDriver = this.filterLatestDriver(allDriverVersions);
        if (latestDriver == null) {
            return null;
        }
        return latestDriver.getVersion();
    }

    private Driver filterLatestDriver(List<Driver> drivers) {
        return (Driver)Lambda.selectMax(drivers, (Object)((Driver)Lambda.on(Driver.class)).getComparableVersion());
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

