/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Platform;

public class Utils {
    public static final String FAKED_OS_NAME_PROPERTY_KEY = "webdriverextensions.faked.os.name";
    public static final String FAKED_BIT_PROPERTY_KEY = "webdriverextensions.faked.bit";

    public static String quote(String text) {
        return "\"" + text + "\"";
    }

    public static String quote(Path path) {
        return Utils.quote(path.toString());
    }

    public static String quote(URL url) {
        return Utils.quote(url.toString());
    }

    public static boolean isWindows() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("windows");
        }
        return Platform.getCurrent().is(Platform.WINDOWS);
    }

    public static boolean isWindows10() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("windows10");
        }
        return Platform.getCurrent().is(Platform.WIN10);
    }

    public static boolean isMac() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("mac");
        }
        return Platform.getCurrent().is(Platform.MAC);
    }

    public static boolean isLinux() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("linux");
        }
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public static boolean is64Bit() {
        if (System.getProperty(FAKED_BIT_PROPERTY_KEY) != null) {
            switch (System.getProperty(FAKED_BIT_PROPERTY_KEY)) {
                case "64": {
                    return true;
                }
                case "32": {
                    return false;
                }
            }
        }
        return com.sun.jna.Platform.is64Bit();
    }

    public static String debugInfo(InstallDriversMojo mojo) {
        return System.lineSeparator() + "downloadDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.downloadDirectory) + System.lineSeparator() + "tempDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.tempDirectory) + System.lineSeparator() + "installationDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.installationDirectory.toPath());
    }

    public static String debugInfo(Driver driver) {
        return System.lineSeparator() + "driver: " + driver;
    }

    public static String debugInfo(InstallDriversMojo mojo, Driver driver) {
        return System.lineSeparator() + System.lineSeparator() + "driver: " + driver + System.lineSeparator() + System.lineSeparator() + "downloadDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.downloadDirectory) + System.lineSeparator() + "tempDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.tempDirectory) + System.lineSeparator() + "installationDirectory: " + System.lineSeparator() + Utils.directoryToString(mojo.installationDirectory.toPath());
    }

    public static String directoryToString(Path path) {
        if (!path.toFile().exists()) {
            return path + " does not exist" + System.lineSeparator();
        }
        if (!path.toFile().isDirectory()) {
            throw new IllegalArgumentException("The path is not a directory: " + path);
        }
        Collection files = FileUtils.listFiles((File)path.toFile(), (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        if (files.size() == 0) {
            return path + " is empty" + System.lineSeparator();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(path);
        stringBuilder.append(System.lineSeparator());
        int padSize = Utils.longestPath(files, path.toFile());
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String relativePath = Utils.getRelativePath(file, path.toFile());
            if (iterator.hasNext()) {
                stringBuilder.append("\u251c\u2500\u2500 ");
            } else {
                stringBuilder.append("\u2514\u2500\u2500 ");
            }
            stringBuilder.append(StringUtils.rightPad((String)relativePath, (int)padSize));
            stringBuilder.append(Utils.readableFileSize(file));
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    private static int longestPath(Collection<File> files, File relativeToPath) {
        int max = 0;
        for (File file : files) {
            int currentPathLength = Utils.getRelativePath(file, relativeToPath).length();
            if (currentPathLength <= max) continue;
            max = currentPathLength;
        }
        return max;
    }

    private static String getRelativePath(File file, File relativeToPath) {
        return StringUtils.replaceOnce((String)file.getAbsolutePath(), (String)(relativeToPath.getAbsolutePath() + File.separator), (String)"");
    }

    private static String readableFileSize(File file) {
        long size = FileUtils.sizeOf((File)file);
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return StringUtils.leftPad((String)new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)), (int)8) + " " + units[digitGroups];
    }

    public static boolean hasExtension(Path downloadFilePath, String zip) {
        return zip.toUpperCase().equals(FilenameUtils.getExtension((String)downloadFilePath.toString()).toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateZipFile(Path filePath) {
        ZipFile zipfile = null;
        ZipInputStream zis = null;
        try {
            zipfile = new ZipFile(filePath.toFile());
            zis = new ZipInputStream(new FileInputStream(filePath.toFile()));
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                boolean bl = false;
                return bl;
            }
            while (ze != null) {
                zipfile.getInputStream(ze);
                ze.getCrc();
                ze.getCompressedSize();
                ze.getName();
                ze = zis.getNextEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (ZipException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (IOException e) {
                return false;
            }
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static boolean validateBz2File(Path filePath) {
        try (FileInputStream fin = new FileInputStream(filePath.toFile());
             BufferedInputStream bin = new BufferedInputStream(fin);){
            BZip2CompressorInputStream ignored = new BZip2CompressorInputStream((InputStream)bin);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean validateFileIsLargerThanBytes(Path filePath, int bytes) {
        return FileUtils.sizeOf((File)filePath.toFile()) > (long)bytes;
    }
}

