/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.ComparableVersion;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;

public class Driver {
    @Expose
    private String name;
    @Expose
    private String platform;
    @Expose
    private String bit;
    @Expose
    private String version;
    @Expose
    private String url;
    @Expose
    private String fileMatchInside;
    @Expose
    private String customFileName;

    public String getId() {
        if (this.customFileName != null && !this.customFileName.isEmpty()) {
            return this.customFileName;
        }
        return this.name + (this.platform != null ? "-" + this.platform : "") + (this.bit != null ? "-" + this.bit + "bit" : "");
    }

    public String getDriverDownloadDirectoryName() {
        return this.name + (this.platform != null ? "-" + this.platform : "") + (this.bit != null ? "-" + this.bit + "bit" : "") + (this.version != null ? "-" + this.version : "");
    }

    public ComparableVersion getComparableVersion() {
        return new ComparableVersion(this.version);
    }

    public String getFileName() {
        if ("windows".equalsIgnoreCase(this.platform)) {
            return this.getId() + ".exe";
        }
        return this.getId();
    }

    public String getFilenameFromUrl() {
        try {
            String file = new URL(this.url).getFile();
            return file.replaceAll(".*\\/", "");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    static Driver fromJson(String json) {
        try {
            return (Driver)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(json, Driver.class);
        }
        catch (Exception ex) {
            return new Driver();
        }
    }

    @Generated
    public Driver() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }

    @Generated
    public String getBit() {
        return this.bit;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getFileMatchInside() {
        return this.fileMatchInside;
    }

    @Generated
    public String getCustomFileName() {
        return this.customFileName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Generated
    public void setBit(String bit) {
        this.bit = bit;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setFileMatchInside(String fileMatchInside) {
        this.fileMatchInside = fileMatchInside;
    }

    @Generated
    public void setCustomFileName(String customFileName) {
        this.customFileName = customFileName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Driver)) {
            return false;
        }
        Driver other = (Driver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$bit = this.getBit();
        String other$bit = other.getBit();
        if (this$bit == null ? other$bit != null : !this$bit.equals(other$bit)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$fileMatchInside = this.getFileMatchInside();
        String other$fileMatchInside = other.getFileMatchInside();
        if (this$fileMatchInside == null ? other$fileMatchInside != null : !this$fileMatchInside.equals(other$fileMatchInside)) {
            return false;
        }
        String this$customFileName = this.getCustomFileName();
        String other$customFileName = other.getCustomFileName();
        return !(this$customFileName == null ? other$customFileName != null : !this$customFileName.equals(other$customFileName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Driver;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $bit = this.getBit();
        result = result * 59 + ($bit == null ? 43 : $bit.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $fileMatchInside = this.getFileMatchInside();
        result = result * 59 + ($fileMatchInside == null ? 43 : $fileMatchInside.hashCode());
        String $customFileName = this.getCustomFileName();
        result = result * 59 + ($customFileName == null ? 43 : $customFileName.hashCode());
        return result;
    }
}

