/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojo;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.maven.plugin.MojoExecutionException;

class DriverDownloader
implements Closeable {
    private final InstallDriversMojo mojo;
    private final CloseableHttpClient httpClient;

    public DriverDownloader(InstallDriversMojo mojo) throws MojoExecutionException {
        this.mojo = mojo;
        this.httpClient = this.createHttpClient();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public Path downloadFile(Driver driver, Path downloadDirectory) throws MojoExecutionException {
        String url = driver.getUrl();
        Path downloadFilePath = downloadDirectory.resolve(driver.getFilenameFromUrl());
        if (downloadFilePath.toFile().exists() && this.downloadCompletedFileExists(downloadDirectory)) {
            this.mojo.getLog().info((CharSequence)("  Using cached driver from " + Utils.quote(downloadFilePath)));
        } else {
            block12: {
                this.mojo.getLog().info((CharSequence)("  Downloading " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath)));
                try (CloseableHttpResponse fileDownloadResponse = this.httpClient.execute((ClassicHttpRequest)new HttpGet(url));){
                    HttpEntity remoteFileStream = fileDownloadResponse.getEntity();
                    int statusCode = fileDownloadResponse.getCode();
                    if (200 == statusCode) {
                        FileUtils.copyInputStreamToFile((InputStream)remoteFileStream.getContent(), (File)downloadFilePath.toFile());
                        break block12;
                    }
                    throw new InstallDriversMojoExecutionException("Download failed with status code " + statusCode, this.mojo, driver);
                }
                catch (InstallDriversMojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InstallDriversMojoExecutionException("Failed to download driver from " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath) + " cause of " + e.getCause(), e, this.mojo, driver);
                }
            }
            this.createDownloadCompletedFile(downloadDirectory);
        }
        return downloadFilePath;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)this.mojo.downloadConnectTimeout)).setResponseTimeout(Timeout.ofSeconds((long)this.mojo.downloadResponseTimeout)).build()).disableCookieManagement().disableContentCompression().setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(this.mojo.downloadMaxRetries, TimeValue.ofSeconds((long)this.mojo.downloadRetryDelay)));
        ProxyUtils.getProxyFromSettings(this.mojo.settings, this.mojo.proxyId).ifPresent(proxy -> {
            ProxyUtils.createProxyFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setProxy(arg_0));
            ProxyUtils.createProxyCredentialsFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setDefaultCredentialsProvider(arg_0));
        });
        return httpClientBuilder.build();
    }

    private boolean downloadCompletedFileExists(Path downloadDirectory) {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        return Files.exists(downloadCompletedFile, new LinkOption[0]);
    }

    private void createDownloadCompletedFile(Path downloadDirectory) throws InstallDriversMojoExecutionException {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        if (!Files.exists(downloadCompletedFile, new LinkOption[0])) {
            try {
                Files.createFile(downloadCompletedFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InstallDriversMojoExecutionException("Failed to create download.completed file at " + downloadCompletedFile, e);
            }
        }
    }
}

