/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojo;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.Utils;
import com.github.webdriverextensions.newversion.FileExtractorImpl;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;

class DriverExtractor {
    private final InstallDriversMojo mojo;

    DriverExtractor(InstallDriversMojo mojo) {
        this.mojo = mojo;
    }

    Path extractDriver(Driver driver, Path downloadedFile) throws MojoExecutionException {
        FileExtractorImpl fileExtractor = new FileExtractorImpl(driver.getFileMatchInside());
        Path extractDirectory = this.mojo.tempDirectory.resolve(driver.getDriverDownloadDirectoryName());
        try {
            Files.createDirectories(extractDirectory, new FileAttribute[0]);
            if (fileExtractor.isExtractable(downloadedFile)) {
                this.mojo.getLog().info((CharSequence)("  Extracting " + Utils.quote(downloadedFile) + " to temp folder"));
                fileExtractor.extractFile(downloadedFile, extractDirectory);
            } else {
                this.mojo.getLog().info((CharSequence)("  Copying " + Utils.quote(downloadedFile) + " to temp folder"));
                Files.copy(downloadedFile, extractDirectory.resolve(downloadedFile.getFileName()), new CopyOption[0]);
            }
            return extractDirectory;
        }
        catch (Exception e) {
            throw new InstallDriversMojoExecutionException("Failed to extract driver from " + Utils.quote(downloadedFile) + " cause of " + e.getMessage(), e, this.mojo, driver);
        }
    }
}

