/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.ComparableVersion;
import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverComparator;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;

class Repository {
    @Expose
    private List<Driver> drivers;

    Repository() {
    }

    static Repository load(URL repositoryUrl, Optional<Proxy> proxySettings) throws MojoExecutionException {
        String repositoryAsString;
        try {
            repositoryAsString = Repository.downloadAsString(repositoryUrl.toURI(), proxySettings);
        }
        catch (IOException | URISyntaxException e) {
            throw new InstallDriversMojoExecutionException("Failed to download repository from url " + Utils.quote(repositoryUrl), e);
        }
        Repository repository = new Repository();
        try {
            Objects.requireNonNull(StringUtils.trimToNull((String)repositoryAsString), "repository json is empty");
            repository.drivers = ((Repository)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson((String)repositoryAsString, Repository.class)).drivers;
        }
        catch (JsonSyntaxException | NullPointerException e) {
            throw new InstallDriversMojoExecutionException("Failed to parse repository json " + repositoryAsString, e);
        }
        repository.drivers.sort(Repository.driversComparator());
        return repository;
    }

    private static Comparator<Driver> driversComparator() {
        DriverComparator.ById byId = new DriverComparator.ById();
        Comparator byVersion = new DriverComparator.ByVersion().reversed();
        return byId.thenComparing(byVersion);
    }

    private static String downloadAsString(URI url, Optional<Proxy> proxySettings) throws IOException {
        if ("file".equalsIgnoreCase(url.getScheme())) {
            return IOUtils.toString((URI)url, (Charset)StandardCharsets.UTF_8);
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement();
        proxySettings.ifPresent(proxy -> {
            ProxyUtils.createProxyFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setProxy(arg_0));
            ProxyUtils.createProxyCredentialsFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setDefaultCredentialsProvider(arg_0));
        });
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            String string = (String)httpClient.execute((ClassicHttpRequest)new HttpGet(url), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            return string;
        }
    }

    List<Driver> getDrivers(String name, String platform, String bit, String version) {
        return this.filterDrivers(this.drivers, name, platform, bit, version);
    }

    private List<Driver> filterDrivers(List<Driver> driversToFilter, String name, String platform, String bit, String version) {
        return driversToFilter.stream().filter(driver -> name != null ? name.equalsIgnoreCase(driver.getName()) : true).filter(driver -> platform != null ? platform.equalsIgnoreCase(driver.getPlatform()) : true).filter(driver -> bit != null ? bit.equalsIgnoreCase(driver.getBit()) : true).filter(driver -> version != null ? new ComparableVersion(version).equals(driver.getComparableVersion()) : true).collect(Collectors.toList());
    }

    Driver enrichDriver(Driver driver) throws MojoExecutionException {
        List<Driver> drivers;
        if (StringUtils.isBlank((CharSequence)driver.getName())) {
            throw new InstallDriversMojoExecutionException("Driver name must be set in configuration, driver: " + driver);
        }
        if (StringUtils.isNotBlank((CharSequence)driver.getUrl())) {
            return driver;
        }
        if ((StringUtils.isNotBlank((CharSequence)driver.getPlatform()) || StringUtils.isNotBlank((CharSequence)driver.getBit()) || StringUtils.isNotBlank((CharSequence)driver.getVersion())) && this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), driver.getVersion()).isEmpty()) {
            throw new MojoExecutionException("Could not find driver: " + driver + System.lineSeparator() + System.lineSeparator() + "in repository: " + this);
        }
        if (StringUtils.isBlank((CharSequence)driver.getPlatform())) {
            driver.setPlatform(Utils.detectPlatform());
        }
        if (StringUtils.isBlank((CharSequence)driver.getBit())) {
            driver.setBit(Repository.detectBits(driver.getName()));
        }
        if (StringUtils.isBlank((CharSequence)driver.getVersion())) {
            driver.setVersion(this.getLatestDriverVersion(driver.getId()));
        }
        if ((drivers = this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), driver.getVersion())).isEmpty()) {
            if ("64".equals(driver.getBit())) {
                drivers = this.getDrivers(driver.getName(), driver.getPlatform(), "32", driver.getVersion());
                if (drivers.isEmpty()) {
                    return null;
                }
                return this.transferCustomFileName(driver, this.filterLatestDriver(drivers));
            }
            return null;
        }
        return this.transferCustomFileName(driver, drivers.get(0));
    }

    private Driver transferCustomFileName(Driver driver, Driver foundDriver) {
        if (StringUtils.isNotBlank((CharSequence)driver.getCustomFileName())) {
            foundDriver.setCustomFileName(driver.getCustomFileName());
        }
        return foundDriver;
    }

    List<Driver> getLatestDrivers() {
        String platform = Utils.detectPlatform();
        return this.drivers.stream().map(Driver::getName).distinct().map(driverName -> {
            Driver latestDriverComplement;
            List<Driver> driversWithDriverNameAndPlatform = this.getDrivers((String)driverName, platform, null, null);
            String bit = Repository.detectBits(driverName);
            boolean is64Bit = bit.equals("64");
            Driver latestDriver = this.getDriverByBit(bit, driversWithDriverNameAndPlatform);
            if (latestDriver != null) {
                return latestDriver;
            }
            if (is64Bit && (latestDriverComplement = this.getDriverByBit("32", driversWithDriverNameAndPlatform)) != null) {
                return latestDriverComplement;
            }
            return null;
        }).filter(Objects::nonNull).sorted(Repository.driversComparator()).collect(Collectors.toList());
    }

    private Driver getDriverByBit(String bit, List<Driver> driversWithDriverNameAndPlatform) {
        List<Driver> driversWithDriverNameAndPlatformAndBit = this.filterDrivers(driversWithDriverNameAndPlatform, null, null, bit, null);
        return this.filterLatestDriver(driversWithDriverNameAndPlatformAndBit);
    }

    private static String detectBits(String driverName) {
        if (driverName.equals("internetexplorerdriver") && !Utils.isWindows10()) {
            return "32";
        }
        if (Utils.is64Bit()) {
            return "64";
        }
        return "32";
    }

    private String getLatestDriverVersion(String driverId) {
        return this.drivers.stream().filter(driver -> driverId.equalsIgnoreCase(driver.getId())).sorted(Repository.driversComparator()).findFirst().map(Driver::getVersion).orElse(null);
    }

    private Driver filterLatestDriver(List<Driver> drivers) {
        return drivers.stream().sorted(Repository.driversComparator()).findFirst().orElse(null);
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

