/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions.newversion;

import com.github.webdriverextensions.newversion.FileExtractor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;

public class FileExtractorImpl
implements FileExtractor {
    private final Pattern extractPattern;
    private final PathMatcher TAR_BZ2 = FileSystems.getDefault().getPathMatcher("glob:**.tar.bz2");
    private final PathMatcher TAR_GZ = FileSystems.getDefault().getPathMatcher("glob:**.tar.gz");
    private final PathMatcher BZ2 = FileSystems.getDefault().getPathMatcher("glob:**.bz2");
    private final PathMatcher GZ = FileSystems.getDefault().getPathMatcher("glob:**.gz");
    private final PathMatcher TAR = FileSystems.getDefault().getPathMatcher("glob:**.tar");
    private final PathMatcher ZIP = FileSystems.getDefault().getPathMatcher("glob:**.zip");

    public FileExtractorImpl(String extractPattern) {
        this.extractPattern = extractPattern == null ? null : Pattern.compile(extractPattern);
    }

    @Override
    public boolean isExtractable(Path file) {
        return this.TAR_BZ2.matches(file) || this.TAR_GZ.matches(file) || this.BZ2.matches(file) || this.GZ.matches(file) || this.TAR.matches(file) || this.ZIP.matches(file);
    }

    @Override
    public void extractFile(Path file, Path toDirectory) {
        try {
            if (this.TAR_BZ2.matches(file)) {
                this.extractTarBz2File(file, toDirectory);
            } else if (this.TAR_GZ.matches(file)) {
                this.extractTarGzFile(file, toDirectory);
            } else if (this.BZ2.matches(file)) {
                this.extractBz2File(file, toDirectory);
            } else if (this.GZ.matches(file)) {
                this.extractGzFile(file, toDirectory);
            } else if (this.TAR.matches(file)) {
                this.extractTarFile(file, toDirectory);
            } else if (this.ZIP.matches(file)) {
                this.extractZipFile(file, toDirectory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void extractBz2File(Path file, Path toDirectory) throws IOException {
        String extractedFilename = FilenameUtils.getBaseName((String)file.toString());
        Path fileToExtract = toDirectory.resolve(extractedFilename);
        try (FileInputStream fin = new FileInputStream(file.toFile());
             BufferedInputStream bin = new BufferedInputStream(fin);
             BZip2CompressorInputStream bzip2Archive = new BZip2CompressorInputStream((InputStream)bin);){
            Files.copy((InputStream)bzip2Archive, fileToExtract, new CopyOption[0]);
        }
    }

    private void extractGzFile(Path file, Path toDirectory) throws IOException {
        String extractedFilename = FilenameUtils.getBaseName((String)file.toString());
        Path fileToExtract = toDirectory.resolve(extractedFilename);
        try (FileInputStream fin = new FileInputStream(file.toFile());
             BufferedInputStream bin = new BufferedInputStream(fin);
             GzipCompressorInputStream gzipArchive = new GzipCompressorInputStream((InputStream)bin);){
            Files.copy((InputStream)gzipArchive, fileToExtract, new CopyOption[0]);
        }
    }

    private void extractTarFile(Path file, Path toDirectory) throws IOException {
        Files.createDirectories(toDirectory, new FileAttribute[0]);
        try (FileInputStream fis = new FileInputStream(file.toFile());
             BufferedInputStream bis = new BufferedInputStream(fis);
             TarArchiveInputStream tarArchive = new TarArchiveInputStream((InputStream)bis);){
            this.extractTar(toDirectory, tarArchive);
        }
    }

    private void extractTarBz2File(Path file, Path toDirectory) throws IOException {
        Files.createDirectories(toDirectory, new FileAttribute[0]);
        try (FileInputStream fin = new FileInputStream(file.toFile());
             BufferedInputStream bin = new BufferedInputStream(fin);
             BZip2CompressorInputStream bzip2Archive = new BZip2CompressorInputStream((InputStream)bin);
             TarArchiveInputStream tarArchive = new TarArchiveInputStream((InputStream)bzip2Archive);){
            this.extractTar(toDirectory, tarArchive);
        }
    }

    private void extractTar(Path toDirectory, TarArchiveInputStream tarArchive) throws IOException {
        TarArchiveEntry tarEntry = tarArchive.getNextTarEntry();
        while (tarEntry != null) {
            if (tarEntry.isDirectory()) {
                Path fileToExtract = toDirectory.resolve(tarEntry.getName());
                if (this.extractPattern == null && FileExtractorImpl.isPathSaveToUse(fileToExtract, toDirectory)) {
                    Files.createDirectories(fileToExtract, new FileAttribute[0]);
                }
            } else if (!tarEntry.isSymbolicLink()) {
                this.extractPattern(toDirectory, tarArchive, tarEntry);
            }
            tarEntry = tarArchive.getNextTarEntry();
        }
    }

    private void extractPattern(Path toDirectory, TarArchiveInputStream tarArchive, TarArchiveEntry tarEntry) throws IOException {
        Path fileToExtract = toDirectory.resolve(tarEntry.getName());
        if (this.extractPattern != null) {
            if (!this.extractPattern.matcher(tarEntry.getName()).matches()) {
                return;
            }
            Path filename = Paths.get(tarEntry.getName(), new String[0]).getFileName();
            fileToExtract = toDirectory.resolve(filename);
        }
        if (FileExtractorImpl.isPathSaveToUse(fileToExtract, toDirectory)) {
            if (!Files.isDirectory(fileToExtract.getParent(), new LinkOption[0])) {
                Files.createDirectories(fileToExtract.getParent(), new FileAttribute[0]);
            }
            Files.copy((InputStream)tarArchive, fileToExtract, new CopyOption[0]);
        }
    }

    private void extractTarGzFile(Path file, Path toDirectory) throws IOException {
        Files.createDirectories(toDirectory, new FileAttribute[0]);
        try (FileInputStream fin = new FileInputStream(file.toFile());
             BufferedInputStream bin = new BufferedInputStream(fin);
             GzipCompressorInputStream gzipArchive = new GzipCompressorInputStream((InputStream)bin);
             TarArchiveInputStream tarArchive = new TarArchiveInputStream((InputStream)gzipArchive);){
            this.extractTar(toDirectory, tarArchive);
        }
    }

    private void extractZipFile(Path file, Path toDirectory) throws IOException {
        Files.createDirectories(toDirectory, new FileAttribute[0]);
        try (FileInputStream fis = new FileInputStream(file.toFile());
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipArchiveInputStream zipArchive = new ZipArchiveInputStream((InputStream)bis);){
            ZipArchiveEntry zipEntry = zipArchive.getNextZipEntry();
            while (zipEntry != null) {
                block25: {
                    Path fileToExtract;
                    block26: {
                        block24: {
                            fileToExtract = toDirectory.resolve(zipEntry.getName());
                            if (!zipEntry.isDirectory()) break block24;
                            if (this.extractPattern == null && FileExtractorImpl.isPathSaveToUse(fileToExtract, toDirectory)) {
                                Files.createDirectories(fileToExtract, new FileAttribute[0]);
                            }
                            break block25;
                        }
                        if (zipEntry.isUnixSymlink()) break block25;
                        if (this.extractPattern == null) break block26;
                        if (!this.extractPattern.matcher(zipEntry.getName()).matches()) break block25;
                        Path filename = Paths.get(zipEntry.getName(), new String[0]).getFileName();
                        fileToExtract = toDirectory.resolve(filename);
                    }
                    if (FileExtractorImpl.isPathSaveToUse(fileToExtract, toDirectory)) {
                        if (!Files.isDirectory(fileToExtract.getParent(), new LinkOption[0])) {
                            Files.createDirectories(fileToExtract.getParent(), new FileAttribute[0]);
                        }
                        Files.copy((InputStream)zipArchive, fileToExtract, new CopyOption[0]);
                    }
                }
                zipEntry = zipArchive.getNextZipEntry();
            }
        }
    }

    private static boolean isPathSaveToUse(Path pathToTest, Path expectedParent) {
        return pathToTest.normalize().startsWith(expectedParent);
    }
}

