/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.Utils;
import com.github.webdriverextensions.newversion.FileExtractorImpl;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

class DriverExtractor {
    private final Log log;
    private final Path tempDirectory;

    Path extractDriver(Driver driver, Path downloadedFile) throws MojoExecutionException {
        FileExtractorImpl fileExtractor = new FileExtractorImpl(driver.getFileMatchInside());
        Path extractDirectory = this.tempDirectory.resolve(driver.getDriverDownloadDirectoryName());
        try {
            Files.createDirectories(extractDirectory, new FileAttribute[0]);
            if (fileExtractor.isExtractable(downloadedFile)) {
                this.log.info((CharSequence)("  Extracting " + Utils.quote(downloadedFile) + " to temp folder"));
                fileExtractor.extractFile(downloadedFile, extractDirectory);
            } else {
                this.log.info((CharSequence)("  Copying " + Utils.quote(downloadedFile) + " to temp folder"));
                Files.copy(downloadedFile, extractDirectory.resolve(downloadedFile.getFileName()), new CopyOption[0]);
            }
            return extractDirectory;
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to extract driver from " + Utils.quote(downloadedFile), driver, e);
        }
    }

    @Generated
    DriverExtractor(Log log, Path tempDirectory) {
        this.log = log;
        this.tempDirectory = tempDirectory;
    }
}

