/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Architecture;
import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverComparator;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.util.StringUtils;

class Repository {
    @Expose
    private List<Driver> drivers;

    Repository() {
    }

    static Repository load(URL repositoryUrl, Optional<Proxy> proxySettings) throws MojoExecutionException {
        String repositoryAsString;
        try {
            repositoryAsString = Repository.downloadAsString(repositoryUrl.toURI(), proxySettings);
        }
        catch (IOException | URISyntaxException e) {
            throw new InstallDriversMojoExecutionException("Failed to download repository from url " + Utils.quote(repositoryUrl), e);
        }
        if (StringUtils.isBlank((String)StringUtils.trim((String)repositoryAsString))) {
            throw new InstallDriversMojoExecutionException("repository file is empty");
        }
        Repository repository = new Repository();
        try {
            repository.drivers = ((Repository)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson((String)repositoryAsString, Repository.class)).drivers;
        }
        catch (JsonSyntaxException e) {
            throw new InstallDriversMojoExecutionException("Failed to parse repository json " + Utils.quote(repositoryUrl), e);
        }
        repository.drivers.sort(Repository.driversComparator());
        return repository;
    }

    private static Comparator<Driver> driversComparator() {
        DriverComparator.ById byId = new DriverComparator.ById();
        Comparator byVersion = new DriverComparator.ByVersion().reversed();
        DriverComparator.ByArch byArch = new DriverComparator.ByArch();
        return byId.thenComparing(byVersion).thenComparing(byArch);
    }

    private static String downloadAsString(URI url, Optional<Proxy> proxySettings) throws IOException {
        if ("file".equalsIgnoreCase(url.getScheme())) {
            return Files.lines(Paths.get(url)).collect(Collectors.joining());
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().disableCookieManagement();
        proxySettings.ifPresent(proxy -> {
            ProxyUtils.createProxyFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setProxy(arg_0));
            ProxyUtils.createProxyCredentialsFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setDefaultCredentialsProvider(arg_0));
        });
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            String string = (String)httpClient.execute((ClassicHttpRequest)new HttpGet(url), (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
            return string;
        }
    }

    List<Driver> getDrivers(@Nullable String name, @Nullable String platform, @Nullable String bit, @Nullable Architecture arch, @Nullable String version) {
        return this.filterDrivers(this.drivers, name, platform, bit, arch, version);
    }

    private List<Driver> filterDrivers(@Nonnull List<Driver> driversToFilter, @Nullable String name, @Nullable String platform, @Nullable String bit, @Nullable Architecture arch, @Nullable String version) {
        return driversToFilter.stream().filter(driver -> name != null ? name.equalsIgnoreCase(driver.getName()) : true).filter(driver -> platform != null ? platform.equalsIgnoreCase(driver.getPlatform()) : true).filter(driver -> bit != null ? bit.equalsIgnoreCase(driver.getBit()) : true).filter(driver -> arch != null && StringUtils.isNotBlank((String)driver.getArch()) ? arch == driver.getArchitecture() : true).filter(driver -> version != null ? new ComparableVersion(version).equals((Object)driver.getComparableVersion()) : true).collect(Collectors.toList());
    }

    Driver enrichDriver(Driver driver) throws MojoExecutionException {
        List<Driver> drivers;
        if (StringUtils.isBlank((String)driver.getName())) {
            throw new InstallDriversMojoExecutionException("Driver name must be set in configuration", driver, null);
        }
        if (StringUtils.isNotBlank((String)driver.getUrl())) {
            return driver;
        }
        if ((StringUtils.isNotBlank((String)driver.getPlatform()) || StringUtils.isNotBlank((String)driver.getBit()) || StringUtils.isNotBlank((String)driver.getVersion())) && this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), null, driver.getVersion()).isEmpty()) {
            throw new InstallDriversMojoExecutionException("Could not find driver", driver, null);
        }
        if (StringUtils.isBlank((String)driver.getPlatform())) {
            driver.setPlatform(Utils.detectPlatform());
        }
        if (StringUtils.isBlank((String)driver.getBit())) {
            driver.setBit(Repository.detectBits(driver.getName()));
        }
        if (StringUtils.isBlank((String)driver.getVersion())) {
            driver.setVersion(this.getLatestDriverVersion(driver.getId()));
        }
        if (StringUtils.isBlank((String)driver.getArch())) {
            driver.setArch(Utils.detectArch().toString());
        }
        if ((drivers = this.getDrivers(driver.getName(), driver.getPlatform(), driver.getBit(), driver.getArchitecture(), driver.getVersion())).isEmpty()) {
            if ("64".equals(driver.getBit())) {
                drivers = this.getDrivers(driver.getName(), driver.getPlatform(), "32", driver.getArchitecture(), driver.getVersion());
                if (drivers.isEmpty()) {
                    return null;
                }
                return this.transferCustomFileName(driver, this.filterLatestDriver(drivers));
            }
            return null;
        }
        return this.transferCustomFileName(driver, drivers.get(0));
    }

    private Driver transferCustomFileName(Driver driver, Driver foundDriver) {
        if (StringUtils.isNotBlank((String)driver.getCustomFileName())) {
            foundDriver.setCustomFileName(driver.getCustomFileName());
        }
        return foundDriver;
    }

    List<Driver> getLatestDrivers() {
        String platform = Utils.detectPlatform();
        Architecture arch = Utils.detectArch();
        return this.drivers.stream().map(Driver::getName).distinct().map(driverName -> {
            List<Driver> driversWithDriverNameAndPlatform = this.getDrivers((String)driverName, platform, null, arch, null);
            String bit = Repository.detectBits(driverName);
            Driver latestDriver = this.getDriverByBit(bit, driversWithDriverNameAndPlatform);
            if (latestDriver == null && bit.equals("64")) {
                latestDriver = this.getDriverByBit("32", driversWithDriverNameAndPlatform);
            }
            return latestDriver;
        }).filter(Objects::nonNull).sorted(Repository.driversComparator()).collect(Collectors.toList());
    }

    private Driver getDriverByBit(String bit, List<Driver> driversWithDriverNameAndPlatform) {
        List<Driver> driversWithDriverNameAndPlatformAndBit = this.filterDrivers(driversWithDriverNameAndPlatform, null, null, bit, null, null);
        return this.filterLatestDriver(driversWithDriverNameAndPlatformAndBit);
    }

    private static String detectBits(String driverName) {
        if (driverName.equals("internetexplorerdriver") && !Utils.isWindows10()) {
            return "32";
        }
        return Utils.detectBits();
    }

    private String getLatestDriverVersion(String driverId) {
        return this.drivers.stream().filter(driver -> driverId.equalsIgnoreCase(driver.getId())).sorted(Repository.driversComparator()).findFirst().map(Driver::getVersion).orElse(null);
    }

    private Driver filterLatestDriver(List<Driver> drivers) {
        return drivers.stream().sorted(Repository.driversComparator()).findFirst().orElse(null);
    }

    public String toString() {
        return new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create().toJson((Object)this);
    }
}

