/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public enum Architecture {
    X86("x86"),
    AMD64("amd64"),
    ARM64("aarch64"),
    IA64("ia64"),
    UNKNOWN("unknown");

    private final String archName;

    @Nonnull
    static Architecture extractFromSysProperty() {
        return Architecture.fromArchName(System.getProperty("os.arch", Architecture.UNKNOWN.archName));
    }

    @Nonnull
    public static Architecture fromArchName(@Nullable String archName) {
        return Stream.of(Architecture.values()).filter(value -> value.archName.equalsIgnoreCase(archName)).findAny().orElse(UNKNOWN);
    }

    public String toString() {
        return this.archName;
    }

    @Generated
    private Architecture(String archName) {
        this.archName = archName;
    }
}

