/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;

class DriverDownloader
implements Closeable {
    private final Log log;
    private CloseableHttpClient httpClient;
    private int connectTimeout;
    private int responseTimeout;
    private int maxRetries;
    private int retryDelay;
    private Optional<Proxy> proxy = Optional.empty();

    void open() {
        this.httpClient = this.createHttpClient();
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    DriverDownloader withTimeouts(int connectTimeout, int responseTimeout) {
        this.connectTimeout = connectTimeout;
        this.responseTimeout = responseTimeout;
        return this;
    }

    DriverDownloader withProxy(@Nonnull Optional<Proxy> proxy) {
        this.proxy = proxy;
        return this;
    }

    DriverDownloader withRetry(int maxRetries, int retryDelay) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        return this;
    }

    Path downloadFile(Driver driver, Path baseDownloadDirectory) throws MojoExecutionException {
        String url = driver.getUrl();
        Path downloadDirectory = baseDownloadDirectory.resolve(driver.getDriverDownloadDirectoryName());
        Path downloadFilePath = downloadDirectory.resolve(driver.getFilenameFromUrl());
        if (downloadFilePath.toFile().exists() && this.downloadCompletedFileExists(downloadDirectory)) {
            this.log.info((CharSequence)("  Using cached driver from " + Utils.quote(downloadFilePath)));
        } else {
            this.log.info((CharSequence)("  Downloading " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath)));
            try {
                this.httpClient.execute((ClassicHttpRequest)new HttpGet(url), fileDownloadResponse -> {
                    int statusCode = fileDownloadResponse.getCode();
                    if (200 != statusCode) {
                        throw new ClientProtocolException(String.valueOf(statusCode));
                    }
                    Files.createDirectories(downloadFilePath, new FileAttribute[0]);
                    Files.copy(fileDownloadResponse.getEntity().getContent(), downloadFilePath, StandardCopyOption.REPLACE_EXISTING);
                    return null;
                });
            }
            catch (ClientProtocolException e) {
                throw new InstallDriversMojoExecutionException("Download failed with status code " + e.getLocalizedMessage(), driver, null);
            }
            catch (IOException e) {
                throw new InstallDriversMojoExecutionException("Failed to download driver from " + Utils.quote(url) + " to " + Utils.quote(downloadFilePath), driver, e);
            }
            this.createDownloadCompletedFile(downloadDirectory);
        }
        return downloadFilePath;
    }

    private CloseableHttpClient createHttpClient() {
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)this.connectTimeout)).build();
        PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connConfig).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofSeconds((long)this.responseTimeout)).build()).disableCookieManagement().disableContentCompression().setConnectionManager((HttpClientConnectionManager)connManager).setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(this.maxRetries, TimeValue.ofSeconds((long)this.retryDelay)));
        this.proxy.ifPresent(proxy -> {
            ProxyUtils.createProxyFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setProxy(arg_0));
            ProxyUtils.createProxyCredentialsFromSettings(proxy).ifPresent(arg_0 -> ((HttpClientBuilder)httpClientBuilder).setDefaultCredentialsProvider(arg_0));
        });
        return httpClientBuilder.build();
    }

    private boolean downloadCompletedFileExists(Path downloadDirectory) {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        return Files.exists(downloadCompletedFile, new LinkOption[0]);
    }

    private void createDownloadCompletedFile(Path downloadDirectory) throws InstallDriversMojoExecutionException {
        Path downloadCompletedFile = downloadDirectory.resolve("download.completed");
        if (!Files.exists(downloadCompletedFile, new LinkOption[0])) {
            try {
                Files.createFile(downloadCompletedFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InstallDriversMojoExecutionException("Failed to create download.completed file at " + Utils.quote(downloadCompletedFile), e);
            }
        }
    }

    @Generated
    DriverDownloader(Log log) {
        this.log = log;
    }
}

