/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverVersionHandler;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;

class DriverInstaller {
    private final Path installationDirectory;
    private final Log log;
    private final DriverVersionHandler versionHandler;
    private Properties driverPathProperyTarget;

    DriverInstaller(Log log, Path installationDirectory) {
        this.log = log;
        this.installationDirectory = installationDirectory;
        this.versionHandler = new DriverVersionHandler(installationDirectory);
    }

    boolean needInstallation(Driver driver) {
        try {
            return !this.isInstalled(driver) || !this.versionHandler.isSameVersion(driver);
        }
        catch (MojoExecutionException ex) {
            this.log.warn((CharSequence)"Could not determine if same version of driver is already installed, will install it again", (Throwable)ex);
            return true;
        }
    }

    void install(Driver driver, Path extractLocation) throws MojoExecutionException {
        this.log.info((CharSequence)("start installing : " + driver.getName() + " from " + extractLocation));
        if (extractLocation.toFile().isDirectory() && this.directoryIsEmpty(extractLocation)) {
            throw new InstallDriversMojoExecutionException("Failed to install driver since no files found to install", driver, null);
        }
        try {
            Files.createDirectories(this.installationDirectory, new FileAttribute[0]);
            if (this.directoryContainsSingleDirectory(extractLocation)) {
                Path singleDirectory = extractLocation.toFile().listFiles()[0].toPath();
                this.moveAllFilesInDirectory(singleDirectory, this.installationDirectory.resolve(driver.getId()));
            } else if (this.directoryContainsSingleFile(extractLocation)) {
                String newFileName = driver.getFileName();
                this.moveFileInDirectory(extractLocation, this.installationDirectory, newFileName);
                this.makeExecutable(this.installationDirectory.resolve(newFileName));
                this.setDriverPathProperty(driver, this.installationDirectory.resolve(newFileName));
            } else {
                this.moveAllFilesInDirectory(extractLocation, this.installationDirectory.resolve(driver.getId()));
            }
            this.versionHandler.writeVersionFile(driver);
        }
        catch (IOException | MojoExecutionException e) {
            throw new InstallDriversMojoExecutionException("Failed to install driver", driver, e);
        }
    }

    void setDriverPathPropertyIfInstalled(Driver driver) {
        if (this.isInstalled(driver)) {
            this.setDriverPathProperty(driver, this.installationDirectory.resolve(driver.getFileName()));
        }
    }

    private void setDriverPathProperty(Driver driver, Path location) {
        String driverName = driver.getName().toLowerCase();
        String propertyName = "";
        if (driverName.startsWith("chrome") || driverName.startsWith("chromium")) {
            propertyName = "chrome";
        } else if (driverName.startsWith("opera")) {
            propertyName = "opera";
        } else if (driverName.startsWith("internetexplorer")) {
            propertyName = "ie";
        } else if (driverName.startsWith("edge")) {
            propertyName = "edge";
        } else if (driverName.startsWith("gecko") || driverName.startsWith("firefox")) {
            propertyName = "gecko";
        }
        if (this.driverPathProperyTarget != null && !propertyName.isEmpty() && driver.getPlatform().equalsIgnoreCase(Utils.detectPlatform())) {
            this.driverPathProperyTarget.putIfAbsent(String.format("webdriver.%s.driver", propertyName), location.toAbsolutePath().toString());
        }
    }

    private boolean isInstalled(Driver driver) {
        Path path = this.installationDirectory.resolve(driver.getFileName());
        return path.toFile().exists();
    }

    private boolean directoryIsEmpty(Path directory) {
        return directory.toFile().listFiles().length == 0;
    }

    private boolean directoryContainsSingleFile(Path directory) throws MojoExecutionException {
        File[] files = directory.toFile().listFiles();
        return files != null && files.length == 1 && files[0].isFile();
    }

    private boolean directoryContainsSingleDirectory(Path directory) {
        File[] files = directory.toFile().listFiles();
        return files != null && files.length == 1 && files[0].isDirectory();
    }

    private void moveFileInDirectory(Path from, Path to, String newFileName) throws MojoExecutionException {
        assert (this.directoryContainsSingleFile(from));
        try {
            File[] files = from.toFile().listFiles();
            Path singleFile = files[0].toPath();
            this.log.info((CharSequence)("  Moving (one File) " + Utils.quote(singleFile) + " to " + Utils.quote(to.resolve(newFileName))));
            FileUtils.forceDelete((File)to.resolve(newFileName).toFile());
            Files.move(singleFile, to.resolve(newFileName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to move file in directory " + Utils.quote(from) + " to " + Utils.quote(to.resolve(newFileName)), e);
        }
    }

    private void moveAllFilesInDirectory(Path from, Path to) throws MojoExecutionException {
        try {
            Files.createDirectories(to, new FileAttribute[0]);
            for (File file : from.toFile().listFiles()) {
                this.log.info((CharSequence)("  Moving (All Files) " + file + " to " + to.resolve(file.toPath().getFileName())));
                FileUtils.forceDelete((File)to.resolve(file.toPath().getFileName()).toFile());
                if (Os.isFamily((String)"windows") && file.isDirectory()) {
                    FileUtils.copyDirectory((File)file, (File)to.resolve(file.toPath().getFileName()).toFile());
                    FileUtils.forceDelete((File)file);
                } else {
                    Files.move(file.toPath(), to.resolve(file.toPath().getFileName()), StandardCopyOption.REPLACE_EXISTING);
                }
                this.makeExecutable(to.resolve(file.toPath().getFileName()));
            }
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to move directory " + Utils.quote(from) + " to " + Utils.quote(to), e);
        }
    }

    private void makeExecutable(Path path) {
        File file = path.toFile();
        if (file.exists() && !file.canExecute()) {
            file.setExecutable(true);
        }
    }

    @Generated
    public void setDriverPathProperyTarget(Properties driverPathProperyTarget) {
        this.driverPathProperyTarget = driverPathProperyTarget;
    }
}

