/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Driver;
import com.github.webdriverextensions.DriverDownloader;
import com.github.webdriverextensions.DriverExtractor;
import com.github.webdriverextensions.DriverInstaller;
import com.github.webdriverextensions.InstallDriversMojoExecutionException;
import com.github.webdriverextensions.ProxyUtils;
import com.github.webdriverextensions.Repository;
import com.github.webdriverextensions.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.UncheckedException;
import org.jooq.lambda.tuple.Tuple;

@Mojo(name="install-drivers", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresOnline=true)
public class InstallDriversMojo
extends AbstractMojo {
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    Settings settings;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(defaultValue="https://raw.githubusercontent.com/webdriverextensions/webdriverextensions-maven-plugin-repository/master/repository-3.0.json", property="webdriverextensions.repoUrl")
    URL repositoryUrl;
    @Parameter(defaultValue="${basedir}/drivers", property="webdriverextensions.installDirectory")
    File installationDirectory;
    @Parameter(property="webdriverextensions.proxyId")
    String proxyId;
    @Parameter
    List<Driver> drivers = new ArrayList<Driver>();
    @Parameter(defaultValue="false", property="webdriverextensions.skip")
    boolean skip;
    @Parameter(defaultValue="false", property="webdriverextensions.skipIgnore")
    boolean skipIgnore;
    @Parameter(defaultValue="1800", property="webdriverextensions.download.responseTimeout")
    int downloadResponseTimeout;
    @Parameter(defaultValue="30", property="webdriverextensions.download.connectTimeout")
    int downloadConnectTimeout;
    @Parameter(defaultValue="3", property="webdriverextensions.download.maxRetries")
    int downloadMaxRetries;
    @Parameter(defaultValue="3", property="webdriverextensions.download.retryDelay")
    int downloadRetryDelay;
    @Parameter(defaultValue="false", property="webdriverextensions.download.keepFiles")
    boolean keepDownloadedWebdrivers;
    @Parameter(property="webdriverextensions.workingDirectory")
    File pluginWorkingDirectory;
    @Parameter(defaultValue="false", property="webdriverextensions.setWebdriverPath")
    boolean setWebdriverPath;
    Path downloadDirectory;
    Path tempDirectory;
    Repository repository;

    private void setupDirectories() throws MojoExecutionException {
        try {
            if (this.pluginWorkingDirectory == null) {
                this.pluginWorkingDirectory = Files.createTempDirectory("webdriverextensions-maven-plugin", new FileAttribute[0]).toFile();
            }
            if (!Files.isDirectory(this.pluginWorkingDirectory.toPath(), new LinkOption[0])) {
                Files.createDirectories(this.pluginWorkingDirectory.toPath(), new FileAttribute[0]);
            }
            this.downloadDirectory = this.pluginWorkingDirectory.toPath().resolve("downloads");
            this.tempDirectory = Files.createTempDirectory(this.pluginWorkingDirectory.toPath(), "temp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("error while creating folders", e);
        }
    }

    private boolean doSkip() {
        if (this.skipIgnore) {
            return false;
        }
        if (this.skip) {
            return true;
        }
        return Stream.of("skipTests", "skipITs", "maven.test.skip").map(Boolean::getBoolean).anyMatch(Boolean.TRUE::equals);
    }

    public void execute() throws MojoExecutionException {
        if (this.doSkip()) {
            this.getLog().info((CharSequence)"Skipping install-drivers goal execution");
            return;
        }
        this.repository = Repository.load(this.repositoryUrl, ProxyUtils.getProxyFromSettings(this.settings, this.proxyId));
        this.getLog().info((CharSequence)("Installation directory " + Utils.quote(this.installationDirectory.toPath())));
        if (this.drivers.isEmpty()) {
            this.getLog().info((CharSequence)"Installing latest drivers for current platform");
            this.drivers = this.repository.getLatestDrivers();
        } else {
            this.getLog().info((CharSequence)"Installing drivers from configuration");
        }
        if (this.keepDownloadedWebdrivers && this.pluginWorkingDirectory == null) {
            this.getLog().warn((CharSequence)"keepDownloadedWebdrivers is true but pluginWorkingDirectory is not set! Please configure pluginWorkingDirectory as well.");
            this.keepDownloadedWebdrivers = false;
        }
        this.setupDirectories();
        this.performInstallation();
        if (this.keepDownloadedWebdrivers) {
            this.cleanupTempDirectory();
        } else {
            this.cleanupWorkingDirectory();
        }
    }

    private void performInstallation() throws MojoExecutionException {
        DriverExtractor driverExtractor = this.createExtractor();
        DriverInstaller driverInstaller = this.createInstaller();
        try (DriverDownloader driverDownloader2 = this.createDownloader();){
            driverDownloader2.open();
            this.drivers.stream().map(Unchecked.function(this.repository::enrichDriver)).filter(Objects::nonNull).peek(driverInstaller::setDriverPathPropertyIfInstalled).filter(driverInstaller::needInstallation).peek(driver -> this.getLog().info((CharSequence)(driver.getId() + " version " + driver.getVersion()))).map(Unchecked.function(driver -> {
                Path downloadLocation = driverDownloader2.downloadFile((Driver)driver, this.downloadDirectory);
                return Tuple.tuple((Object)driver, (Object)downloadLocation);
            })).map(Unchecked.function(t -> {
                Path extractLocation = driverExtractor.extractDriver((Driver)t.v1, (Path)t.v2);
                return Tuple.tuple((Object)((Driver)t.v1), (Object)extractLocation);
            })).forEach(Unchecked.consumer(t -> driverInstaller.install((Driver)t.v1, (Path)t.v2)));
        }
        catch (IOException driverDownloader2) {
        }
        catch (UncheckedException ex) {
            if (ex.getCause() instanceof InstallDriversMojoExecutionException) {
                InstallDriversMojoExecutionException mojoError = (InstallDriversMojoExecutionException)((Object)ex.getCause());
                mojoError.setLongMessage(String.format("driver: %s%n%ndownloadDirectory: %s%n%ntempDirectory: %s%n%ninstallationDirectory: %s", mojoError.getSource(), Utils.directoryToString(this.downloadDirectory), Utils.directoryToString(this.tempDirectory), Utils.directoryToString(this.installationDirectory.toPath())));
                throw mojoError;
            }
            throw new InstallDriversMojoExecutionException(ex.getMessage(), ex);
        }
    }

    private DriverExtractor createExtractor() {
        return new DriverExtractor(this.getLog(), this.tempDirectory);
    }

    private DriverInstaller createInstaller() {
        DriverInstaller driverInstaller = new DriverInstaller(this.getLog(), this.installationDirectory.toPath());
        if (this.setWebdriverPath) {
            driverInstaller.setDriverPathProperyTarget(this.session.getUserProperties());
        }
        return driverInstaller;
    }

    DriverDownloader createDownloader() throws MojoExecutionException {
        return new DriverDownloader(this.getLog()).withProxy(ProxyUtils.getProxyFromSettings(this.settings, this.proxyId)).withTimeouts(this.downloadConnectTimeout, this.downloadResponseTimeout).withRetry(this.downloadMaxRetries, this.downloadRetryDelay);
    }

    private void cleanupWorkingDirectory() throws MojoExecutionException {
        try {
            FileUtils.deleteDirectory((File)this.pluginWorkingDirectory);
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to delete plugin working directory:" + System.lineSeparator() + Utils.directoryToString(this.pluginWorkingDirectory.toPath()), e);
        }
    }

    private void cleanupTempDirectory() throws MojoExecutionException {
        try {
            FileUtils.deleteDirectory((File)this.tempDirectory.toFile());
        }
        catch (IOException e) {
            throw new InstallDriversMojoExecutionException("Failed to delete temp directory:" + System.lineSeparator() + Utils.directoryToString(this.tempDirectory), e);
        }
    }
}

