/*
 * Decompiled with CFR 0.152.
 */
package com.github.webdriverextensions;

import com.github.webdriverextensions.Architecture;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.codehaus.plexus.util.StringUtils;
import org.openqa.selenium.Platform;

public final class Utils {
    public static final String FAKED_OS_NAME_PROPERTY_KEY = "webdriverextensions.faked.os.name";
    public static final String FAKED_ARCH_PROPERTY_KEY = "webdriverextensions.faked.os.arch";
    public static final String FAKED_BIT_PROPERTY_KEY = "webdriverextensions.faked.bit";

    public static String quote(String text) {
        return "\"" + text + "\"";
    }

    public static String quote(Path path) {
        return Utils.quote(path.toString());
    }

    public static String quote(URL url) {
        return Utils.quote(url.toString());
    }

    public static boolean isWindows() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("windows");
        }
        return Platform.getCurrent().is(Platform.WINDOWS);
    }

    public static boolean isWindows10() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("windows10");
        }
        return Platform.getCurrent().is(Platform.WIN10);
    }

    public static boolean isMac() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("mac");
        }
        return Platform.getCurrent().is(Platform.MAC);
    }

    public static boolean isLinux() {
        if (System.getProperty(FAKED_OS_NAME_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_OS_NAME_PROPERTY_KEY).equals("linux");
        }
        return Platform.getCurrent().is(Platform.LINUX);
    }

    public static String detectPlatform() {
        if (Utils.isMac()) {
            return "mac";
        }
        if (Utils.isLinux()) {
            return "linux";
        }
        return "windows";
    }

    @Nonnull
    public static Architecture detectArch() {
        if (System.getProperty(FAKED_ARCH_PROPERTY_KEY) != null) {
            return Architecture.fromArchName(System.getProperty(FAKED_ARCH_PROPERTY_KEY));
        }
        return Architecture.extractFromSysProperty();
    }

    public static String detectBits() {
        if (System.getProperty(FAKED_BIT_PROPERTY_KEY) != null) {
            return System.getProperty(FAKED_BIT_PROPERTY_KEY);
        }
        Architecture arch = Utils.detectArch();
        switch (arch) {
            case UNKNOWN: {
                return System.getProperty("sun.arch.data.model");
            }
            case X86: {
                return "32";
            }
        }
        return "64";
    }

    public static String directoryToString(Path path) {
        if (path == null) {
            return "null";
        }
        if (!path.toFile().exists()) {
            return path + " does not exist";
        }
        if (!path.toFile().isDirectory()) {
            return path + " is not a directory";
        }
        Object[] files = path.toFile().listFiles();
        if (files.length == 0) {
            return path + " is empty";
        }
        StringBuilder stringBuilder = new StringBuilder(path.toString());
        int padSize = Utils.longestPath((File[])files, path);
        Arrays.sort(files);
        int l = files.length;
        for (int i = 0; i < l; ++i) {
            stringBuilder.append(System.lineSeparator());
            Object file = files[i];
            String relativePath = Utils.getRelativePath((File)file, path);
            if (i != l - 1) {
                stringBuilder.append("\u251c\u2500\u2500 ");
            } else {
                stringBuilder.append("\u2514\u2500\u2500 ");
            }
            stringBuilder.append(StringUtils.rightPad((String)relativePath, (int)padSize));
            stringBuilder.append(Utils.readableFileSize((File)file));
        }
        return stringBuilder.toString();
    }

    private static int longestPath(File[] files, Path relativeToPath) {
        return Stream.of(files).mapToInt(file -> Utils.getRelativePath(file, relativeToPath).length()).max().orElse(0);
    }

    private static String getRelativePath(File file, Path relativeToPath) {
        return relativeToPath.relativize(file.toPath()).toString();
    }

    private static String readableFileSize(File file) {
        long size = file.length();
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
        int digitGroups = size > 0L ? (int)(Math.log10(size) / Math.log10(1024.0)) : 0;
        return String.format("%8s %s", new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)), units[digitGroups]);
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

