/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AutoUpdateCertificatesVerifier
implements Verifier {
    protected static final Logger log = LoggerFactory.getLogger(AutoUpdateCertificatesVerifier.class);
    private static final String CERT_DOWNLOAD_PATH = "https://api.mch.weixin.qq.com/v3/certificates";
    protected final long minutesInterval;
    protected final Credentials credentials;
    protected final byte[] apiV3Key;
    protected final ReentrantLock lock = new ReentrantLock();
    protected volatile Instant lastUpdateTime;
    protected CertificatesVerifier verifier;
    private static final Validator emptyValidator = new Validator(){

        @Override
        public boolean validate(CloseableHttpResponse response) throws IOException {
            return true;
        }

        @Override
        public String getSerialNumber() {
            return "";
        }
    };

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key) {
        this(credentials, apiV3Key, TimeUnit.HOURS.toMinutes(1L));
    }

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key, long minutesInterval) {
        this.credentials = credentials;
        this.apiV3Key = apiV3Key;
        this.minutesInterval = minutesInterval;
        try {
            this.autoUpdateCert();
            this.lastUpdateTime = Instant.now();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        if ((this.lastUpdateTime == null || Duration.between(this.lastUpdateTime, Instant.now()).toMinutes() >= this.minutesInterval) && this.lock.tryLock()) {
            try {
                this.autoUpdateCert();
                this.lastUpdateTime = Instant.now();
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Auto update cert failed: ", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.verifier.verify(serialNumber, message, signature);
    }

    @Override
    public PublicKey getValidPublicKey() {
        return this.verifier.getValidPublicKey();
    }

    @Override
    public String getSerialNumber() {
        return this.verifier.getSerialNumber();
    }

    protected void autoUpdateCert() throws IOException, GeneralSecurityException {
        try (CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create().withCredentials(this.credentials).withValidator(this.verifier == null ? emptyValidator : new WechatPay2Validator(this.verifier)).build();){
            HttpGet httpGet = new HttpGet(CERT_DOWNLOAD_PATH);
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                int statusCode = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                if (statusCode == 200) {
                    List<X509Certificate> newCertList = this.deserializeToCerts(this.apiV3Key, body);
                    if (newCertList.isEmpty()) {
                        log.warn("Cert list is empty");
                        return;
                    }
                    this.verifier = new CertificatesVerifier(newCertList);
                } else {
                    log.warn("Auto update cert failed, statusCode = {}, body = {}", (Object)statusCode, (Object)body);
                }
            }
        }
    }

    protected List<X509Certificate> deserializeToCerts(byte[] apiV3Key, String body) throws GeneralSecurityException, IOException {
        AesUtil aesUtil = new AesUtil(apiV3Key);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode dataNode = mapper.readTree(body).get("data");
        ArrayList<X509Certificate> newCertList = new ArrayList<X509Certificate>();
        if (dataNode != null) {
            int count = dataNode.size();
            for (int i = 0; i < count; ++i) {
                JsonNode node = dataNode.get(i).get("encrypt_certificate");
                String cert = aesUtil.decryptToString(node.get("associated_data").toString().replace("\"", "").getBytes(StandardCharsets.UTF_8), node.get("nonce").toString().replace("\"", "").getBytes(StandardCharsets.UTF_8), node.get("ciphertext").toString().replace("\"", ""));
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8)));
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    continue;
                }
                newCertList.add(x509Cert);
            }
        }
        return newCertList;
    }
}

