/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.cert;

import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.Validator;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.cert.SafeSingleScheduleExecutor;
import com.wechat.pay.contrib.apache.httpclient.exception.HttpCodeException;
import com.wechat.pay.contrib.apache.httpclient.exception.NotFoundException;
import com.wechat.pay.contrib.apache.httpclient.proxy.HttpProxyFactory;
import com.wechat.pay.contrib.apache.httpclient.util.CertSerializeUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesManager {
    protected static final int UPDATE_INTERVAL_MINUTE = 1440;
    private static final Logger log = LoggerFactory.getLogger(CertificatesManager.class);
    private static final String CERT_DOWNLOAD_PATH = "https://api.mch.weixin.qq.com/v3/certificates";
    private static final String SCHEDULE_UPDATE_CERT_THREAD_NAME = "scheduled_update_cert_thread";
    private static volatile CertificatesManager instance = null;
    private ConcurrentHashMap<String, byte[]> apiV3Keys = new ConcurrentHashMap();
    private HttpProxyFactory proxyFactory;
    private HttpHost proxy;
    private ConcurrentHashMap<String, ConcurrentHashMap<BigInteger, X509Certificate>> certificates = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Credentials> credentialsMap = new ConcurrentHashMap();
    private ScheduledExecutorService executor;
    private static final Validator emptyValidator = new Validator(){

        @Override
        public boolean validate(CloseableHttpResponse response) throws IOException {
            return true;
        }

        @Override
        public String getSerialNumber() {
            return "";
        }
    };

    private CertificatesManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertificatesManager getInstance() {
        if (instance != null) return instance;
        Class<CertificatesManager> clazz = CertificatesManager.class;
        synchronized (CertificatesManager.class) {
            if (instance != null) return instance;
            instance = new CertificatesManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void putMerchant(String merchantId, Credentials credentials, byte[] apiV3Key) throws IOException, GeneralSecurityException, HttpCodeException {
        if (merchantId == null || merchantId.isEmpty()) {
            throw new IllegalArgumentException("merchantId\u4e3a\u7a7a");
        }
        if (credentials == null) {
            throw new IllegalArgumentException("credentials\u4e3a\u7a7a");
        }
        if (apiV3Key.length == 0) {
            throw new IllegalArgumentException("apiV3Key\u4e3a\u7a7a");
        }
        if (this.certificates.get(merchantId) == null) {
            this.certificates.put(merchantId, new ConcurrentHashMap());
        }
        this.initCertificates(merchantId, credentials, apiV3Key);
        this.credentialsMap.put(merchantId, credentials);
        this.apiV3Keys.put(merchantId, apiV3Key);
        if (this.executor == null) {
            this.beginScheduleUpdate();
        }
    }

    public synchronized void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }

    public synchronized void setProxyFactory(HttpProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public synchronized HttpHost resolveProxy() {
        return Objects.nonNull(this.proxyFactory) ? this.proxyFactory.buildHttpProxy() : this.proxy;
    }

    public void stop() {
        if (this.executor != null) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception e) {
                log.error("Executor shutdown now failed", (Throwable)e);
            }
        }
    }

    private X509Certificate getLatestCertificate(String merchantId) throws NotFoundException {
        if (merchantId == null || merchantId.isEmpty()) {
            throw new IllegalArgumentException("merchantId\u4e3a\u7a7a");
        }
        Map merchantCertificates = this.certificates.get(merchantId);
        if (merchantCertificates == null || merchantCertificates.isEmpty()) {
            throw new NotFoundException("\u6ca1\u6709\u6700\u65b0\u7684\u5e73\u53f0\u8bc1\u4e66\uff0cmerchantId:" + merchantId);
        }
        X509Certificate latestCert = null;
        for (X509Certificate x509Cert : merchantCertificates.values()) {
            if (latestCert != null && !x509Cert.getNotBefore().after(latestCert.getNotBefore())) continue;
            latestCert = x509Cert;
        }
        try {
            latestCert.checkValidity();
            return latestCert;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            log.error("\u5e73\u53f0\u8bc1\u4e66\u672a\u751f\u6548\u6216\u5df2\u8fc7\u671f\uff0cmerchantId:{}", (Object)merchantId);
            throw new NotFoundException("\u6ca1\u6709\u6700\u65b0\u7684\u5e73\u53f0\u8bc1\u4e66\uff0cmerchantId:" + merchantId);
        }
    }

    public Verifier getVerifier(String merchantId) throws NotFoundException {
        ConcurrentHashMap<BigInteger, X509Certificate> merchantCertificates = this.certificates.get(merchantId);
        byte[] apiV3Key = this.apiV3Keys.get(merchantId);
        Credentials credentials = this.credentialsMap.get(merchantId);
        if (merchantId == null || merchantId.isEmpty()) {
            throw new IllegalArgumentException("merchantId\u4e3a\u7a7a");
        }
        if (merchantCertificates == null || merchantCertificates.size() == 0) {
            throw new NotFoundException("\u5e73\u53f0\u8bc1\u4e66\u4e3a\u7a7a\uff0cmerchantId:" + merchantId);
        }
        if (apiV3Key.length == 0) {
            throw new NotFoundException("apiV3Key\u4e3a\u7a7a\uff0cmerchantId:" + merchantId);
        }
        if (credentials == null) {
            throw new NotFoundException("credentials\u4e3a\u7a7a\uff0cmerchantId:" + merchantId);
        }
        return new DefaultVerifier(merchantId);
    }

    private void beginScheduleUpdate() {
        this.executor = new SafeSingleScheduleExecutor();
        Runnable runnable = () -> {
            try {
                Thread.currentThread().setName(SCHEDULE_UPDATE_CERT_THREAD_NAME);
                log.info("Begin update Certificates.Date:{}", (Object)Instant.now());
                this.updateCertificates();
                log.info("Finish update Certificates.Date:{}", (Object)Instant.now());
            }
            catch (Throwable t) {
                log.error("Update Certificates failed", t);
            }
        };
        this.executor.scheduleAtFixedRate(runnable, 0L, 1440L, TimeUnit.MINUTES);
    }

    private synchronized void downloadAndUpdateCert(String merchantId, Verifier verifier, Credentials credentials, byte[] apiV3Key) throws HttpCodeException, IOException, GeneralSecurityException {
        block32: {
            this.proxy = this.resolveProxy();
            try (CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create().withCredentials(credentials).withValidator(verifier == null ? emptyValidator : new WechatPay2Validator(verifier)).withProxy(this.proxy).build();){
                HttpGet httpGet = new HttpGet(CERT_DOWNLOAD_PATH);
                httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (statusCode == 200) {
                        Map<BigInteger, X509Certificate> newCertList = CertSerializeUtil.deserializeToCerts(apiV3Key, body);
                        if (newCertList.isEmpty()) {
                            log.warn("Cert list is empty");
                            return;
                        }
                        ConcurrentHashMap<BigInteger, X509Certificate> merchantCertificates = this.certificates.get(merchantId);
                        merchantCertificates.clear();
                        merchantCertificates.putAll(newCertList);
                        break block32;
                    }
                    log.error("Auto update cert failed, statusCode = {}, body = {}", (Object)statusCode, (Object)body);
                    throw new HttpCodeException("\u4e0b\u8f7d\u5e73\u53f0\u8bc1\u4e66\u8fd4\u56de\u72b6\u6001\u7801\u5f02\u5e38\uff0c\u72b6\u6001\u7801\u4e3a:" + statusCode);
                }
            }
        }
    }

    private void initCertificates(String merchantId, Credentials credentials, byte[] apiV3Key) throws HttpCodeException, IOException, GeneralSecurityException {
        this.downloadAndUpdateCert(merchantId, null, credentials, apiV3Key);
    }

    private void updateCertificates() {
        for (Map.Entry<String, Credentials> entry : this.credentialsMap.entrySet()) {
            String merchantId = entry.getKey();
            Credentials credentials = entry.getValue();
            byte[] apiv3Key = this.apiV3Keys.get(merchantId);
            DefaultVerifier verifier = new DefaultVerifier(merchantId);
            try {
                this.downloadAndUpdateCert(merchantId, verifier, credentials, apiv3Key);
            }
            catch (Exception e) {
                log.error("downloadAndUpdateCert Failed.merchantId:{}, e:{}", (Object)merchantId, (Object)e);
            }
        }
    }

    private class DefaultVerifier
    implements Verifier {
        private String merchantId;

        private DefaultVerifier(String merchantId) {
            this.merchantId = merchantId;
        }

        @Override
        public boolean verify(String serialNumber, byte[] message, String signature) {
            if (serialNumber.isEmpty() || message.length == 0 || signature.isEmpty()) {
                throw new IllegalArgumentException("serialNumber\u6216message\u6216signature\u4e3a\u7a7a");
            }
            BigInteger serialNumber16Radix = new BigInteger(serialNumber, 16);
            ConcurrentHashMap merchantCertificates = (ConcurrentHashMap)CertificatesManager.this.certificates.get(this.merchantId);
            X509Certificate certificate = (X509Certificate)merchantCertificates.get(serialNumber16Radix);
            if (certificate == null) {
                log.error("\u5546\u6237\u8bc1\u4e66\u4e3a\u7a7a\uff0cserialNumber:{}", (Object)serialNumber);
                return false;
            }
            try {
                Signature sign = Signature.getInstance("SHA256withRSA");
                sign.initVerify(certificate);
                sign.update(message);
                return sign.verify(Base64.getDecoder().decode(signature));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", e);
            }
            catch (SignatureException e) {
                throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u8fc7\u7a0b\u53d1\u751f\u4e86\u9519\u8bef", e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
            }
        }

        public X509Certificate getValidCertificate() {
            X509Certificate certificate;
            try {
                certificate = CertificatesManager.this.getLatestCertificate(this.merchantId);
            }
            catch (NotFoundException e) {
                throw new NoSuchElementException("\u6ca1\u6709\u6709\u6548\u7684\u5fae\u4fe1\u652f\u4ed8\u5e73\u53f0\u8bc1\u4e66");
            }
            return certificate;
        }

        @Override
        public PublicKey getValidPublicKey() {
            return this.getValidCertificate().getPublicKey();
        }

        @Override
        public String getSerialNumber() {
            return this.getValidCertificate().getSerialNumber().toString(16).toUpperCase();
        }
    }
}

