/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.NativeUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JNIDecorationsMacOS {
    private static final Logger LOGGER = Logger.getLogger(JNIDecorationsMacOS.class.getName());
    private static boolean loaded;
    private static boolean attemptedLoad;

    public static native long getComponentPointer(Window var0);

    public static native void retainWindow(long var0);

    public static native void releaseWindow(long var0);

    public static native double getTitleBarHeight(long var0);

    public static native void installDecorations(long var0);

    public static native void uninstallDecorations(long var0);

    public static native void setTitleEnabled(long var0, boolean var2);

    public static native void setDarkTheme(long var0, boolean var2);

    public static native boolean isFullscreen(long var0);

    public static native double getTitleFontSize(long var0);

    public static void updateLibrary() {
        if (!loaded && !attemptedLoad) {
            JNIDecorationsMacOS.loadLibrary();
        }
    }

    private static void loadLibrary() {
        attemptedLoad = true;
        if (!SystemInfo.isMac || loaded) {
            return;
        }
        try {
            if (SystemInfo.isX64) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-macos/macos-x86-64/libdarklaf-macos.dylib");
                loaded = true;
                LOGGER.info("Loaded libdarklaf-macos.dylib. Decorations are enabled.");
            } else {
                LOGGER.warning("JRE model '" + SystemInfo.jreArchitecture + "' not supported. Decorations will be disabled");
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load decorations library libdarklaf-macos.dylib. Decorations will be disabled", e);
        }
    }

    public static boolean isCustomDecorationSupported() {
        return loaded;
    }
}

