/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos.ui;

import com.github.weisj.darklaf.platform.macos.JNIDecorationsMacOS;
import com.github.weisj.darklaf.platform.macos.ui.DecorationInformation;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class MacOSDecorationsUtil {
    private static final String FULL_WINDOW_CONTENT_KEY = "apple.awt.fullWindowContent";
    private static final String TRANSPARENT_TITLE_BAR_KEY = "apple.awt.transparentTitleBar";

    protected static DecorationInformation installDecorations(JRootPane rootPane) {
        boolean jniInstall;
        if (rootPane == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        long windowHandle = JNIDecorationsMacOS.getComponentPointer(window);
        if (windowHandle == 0L) {
            return new DecorationInformation(0L, false, false, false, rootPane, false, 0, 0.0f);
        }
        JNIDecorationsMacOS.retainWindow(windowHandle);
        boolean fullWindowContent = MacOSDecorationsUtil.isFullWindowContentEnabled(rootPane);
        boolean transparentTitleBar = MacOSDecorationsUtil.isTransparentTitleBarEnabled(rootPane);
        float titleFontSize = (float)JNIDecorationsMacOS.getTitleFontSize(windowHandle);
        int titleBarHeight = (int)JNIDecorationsMacOS.getTitleBarHeight(windowHandle);
        boolean bl = jniInstall = !SystemInfo.isJavaVersionAtLeast((String)"12");
        if (!jniInstall) {
            MacOSDecorationsUtil.setTransparentTitleBarEnabled(rootPane, true);
            MacOSDecorationsUtil.setFullWindowContentEnabled(rootPane, true);
        } else {
            JNIDecorationsMacOS.installDecorations(windowHandle);
        }
        boolean titleVisible = SystemInfo.isMacOSMojave;
        JNIDecorationsMacOS.setTitleEnabled(windowHandle, titleVisible);
        if (titleVisible) {
            boolean isDarkTheme = UIManager.getBoolean("Theme.dark");
            JNIDecorationsMacOS.setDarkTheme(windowHandle, isDarkTheme);
        }
        return new DecorationInformation(windowHandle, fullWindowContent, transparentTitleBar, jniInstall, rootPane, titleVisible, titleBarHeight, titleFontSize);
    }

    protected static void uninstallDecorations(DecorationInformation information) {
        if (information == null || information.windowHandle == 0L) {
            return;
        }
        if (information.jniInstalled) {
            JNIDecorationsMacOS.uninstallDecorations(information.windowHandle);
        } else {
            MacOSDecorationsUtil.setFullWindowContentEnabled(information.rootPane, information.fullWindowContentEnabled);
            MacOSDecorationsUtil.setTransparentTitleBarEnabled(information.rootPane, information.transparentTitleBarEnabled);
        }
        JNIDecorationsMacOS.setTitleEnabled(information.windowHandle, true);
        JNIDecorationsMacOS.releaseWindow(information.windowHandle);
    }

    private static boolean isFullWindowContentEnabled(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty(FULL_WINDOW_CONTENT_KEY));
    }

    private static boolean isTransparentTitleBarEnabled(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty(TRANSPARENT_TITLE_BAR_KEY));
    }

    private static void setFullWindowContentEnabled(JRootPane rootPane, boolean enabled) {
        rootPane.putClientProperty(FULL_WINDOW_CONTENT_KEY, enabled);
    }

    private static void setTransparentTitleBarEnabled(JRootPane rootPane, boolean enabled) {
        rootPane.putClientProperty(TRANSPARENT_TITLE_BAR_KEY, enabled);
    }
}

