/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.platform.macos.JNIThemeInfoMacOS;
import com.github.weisj.darklaf.platform.macos.MacOSThemePreferenceProvider;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Color;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MacOSPreferenceMonitor {
    private static final Logger LOGGER = LogUtil.getLogger(MacOSThemePreferenceProvider.class);
    private final MacOSThemePreferenceProvider preferenceProvider;
    private boolean darkMode;
    private boolean highContrast;
    private Color accentColor;
    private Color selectionColor;
    private long listenerHandle;
    private boolean running;

    public MacOSPreferenceMonitor(MacOSThemePreferenceProvider preferenceProvider) {
        this.preferenceProvider = preferenceProvider;
    }

    private void onNotification() {
        SwingUtilities.invokeLater(() -> {
            boolean newDark = JNIThemeInfoMacOS.isDarkThemeEnabled();
            boolean newHighContrast = JNIThemeInfoMacOS.isHighContrastEnabled();
            Color newAccentColor = JNIThemeInfoMacOS.getAccentColor();
            Color newSelectionColor = JNIThemeInfoMacOS.getSelectionColor();
            if (this.darkMode != newDark || this.highContrast != newHighContrast || !Objects.equals(this.accentColor, newAccentColor) || !Objects.equals(this.selectionColor, newSelectionColor)) {
                this.darkMode = newDark;
                this.accentColor = newAccentColor;
                this.selectionColor = newSelectionColor;
                this.highContrast = newHighContrast;
                this.preferenceProvider.reportPreferenceChange(this.darkMode, this.highContrast, this.accentColor, this.selectionColor);
            }
        });
    }

    private void start() {
        this.darkMode = JNIThemeInfoMacOS.isDarkThemeEnabled();
        this.highContrast = JNIThemeInfoMacOS.isHighContrastEnabled();
        this.accentColor = JNIThemeInfoMacOS.getAccentColor();
        this.selectionColor = JNIThemeInfoMacOS.getSelectionColor();
        this.listenerHandle = JNIThemeInfoMacOS.createPreferenceChangeListener(this::onNotification);
        if (this.listenerHandle == 0L) {
            LOGGER.severe("Could not create notification listener. Monitoring will not be started");
            return;
        }
        this.running = true;
        LOGGER.info("Started preference monitoring.");
    }

    private void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        LOGGER.info("Stopped preference monitoring.");
        JNIThemeInfoMacOS.deletePreferenceChangeListener(this.listenerHandle);
    }

    public void setRunning(boolean running) {
        if (running == this.isRunning()) {
            return;
        }
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

