/*
 * MIT License
 *
 * Copyright (c) 2019-2022 Jannis Weis
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.weisj.darklaf.platform.macos;

import com.github.weisj.darklaf.nativeutil.AbstractLibrary;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.util.LogUtil;

public class MacOSLibrary extends AbstractLibrary {

    private static final String PATH = "/com/github/weisj/darklaf/platform/darklaf-macos";
    private static final String x86_64_PATH = PATH + "/libdarklaf-macos-x86-64.dylib";
    private static final String arm64_PATH = PATH + "/libdarklaf-macos-arm64.dylib";

    private static final MacOSLibrary instance = new MacOSLibrary();

    public static MacOSLibrary get() {
        return instance;
    }

    protected MacOSLibrary() {
        super("darklaf-macos", LogUtil.getLogger(MacOSLibrary.class));
    }

    protected String getArm64Path() {
        return arm64_PATH;
    }

    protected String getX64Path() {
        return x86_64_PATH;
    }

    @Override
    final protected Class<?> getLoaderClass() {
        return MacOSLibrary.class;
    }

    @Override
    public String getLibraryPath() {
        if (SystemInfo.isX86Compatible && SystemInfo.isX64) {
            return getX64Path();
        } else if (SystemInfo.isM1) {
            return getArm64Path();
        } else {
            throw new IllegalStateException("Unsupported arch");
        }
    }

    @Override
    protected boolean canLoad() {
        return ((SystemInfo.isX86Compatible && SystemInfo.isX64) || SystemInfo.isM1) && SystemInfo.isMacOSYosemite;
    }
}
