/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.nativeutil;

import com.github.weisj.darklaf.nativeutil.NativeUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLibrary {
    private final String name;
    protected final Logger logger;
    private boolean loaded;
    private boolean attemptedLoad;

    public AbstractLibrary(String name) {
        this(name, Logger.getLogger(name));
    }

    public AbstractLibrary(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public void updateLibrary() {
        if (!this.isLoaded() && !this.attemptedLoad) {
            this.loadLibrary();
            this.afterLoad();
        }
    }

    protected void afterLoad() {
    }

    private void loadLibrary() {
        this.attemptedLoad = true;
        if (!this.canLoad() || this.isLoaded()) {
            return;
        }
        try {
            String path = this.getLibraryPath();
            if (path != null && !path.isEmpty()) {
                List<NativeUtil.Resource> resources = this.getResourcePaths();
                if (resources == null || resources.isEmpty()) {
                    NativeUtil.loadLibraryFromJar(this.getLoaderClass(), path);
                } else {
                    NativeUtil.loadLibraryFromJarWithExtraResources(this.getLoaderClass(), path, resources);
                }
                this.loaded = true;
                this.info("Loaded " + this.name + " at " + path + ".");
            }
        }
        catch (Throwable e) {
            this.error("Could not load library " + this.name + ".", e);
        }
    }

    protected abstract Class<?> getLoaderClass();

    protected List<NativeUtil.Resource> getResourcePaths() {
        return Collections.emptyList();
    }

    public abstract String getLibraryPath();

    protected abstract boolean canLoad();

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void info(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        }
    }

    protected void warning(String message) {
        if (this.logger != null) {
            this.logger.warning(message);
        }
    }

    protected void error(String message, Throwable e) {
        if (this.logger != null) {
            this.logger.log(Level.SEVERE, message, e);
        }
    }
}

