/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.preferences;

import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.macos.MacOSThemePreferenceProvider;
import com.github.weisj.darklaf.platform.preferences.SystemPreferenceChangeListener;
import com.github.weisj.darklaf.platform.preferences.impl.DefaultThemePreferenceProvider;
import com.github.weisj.darklaf.platform.windows.WindowsThemePreferenceProvider;
import com.github.weisj.darklaf.theme.spec.PreferredThemeStyle;
import com.github.weisj.darklaf.theme.spec.ThemePreferenceProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SystemPreferencesManager {
    private final List<SystemPreferenceChangeListener> listenerList = Collections.synchronizedList(new ArrayList());
    private final ThemePreferenceProvider preferenceProvider;

    public SystemPreferencesManager(boolean allowNativeReporting) {
        this.preferenceProvider = SystemPreferencesManager.createProvider(allowNativeReporting);
        this.preferenceProvider.setCallback(this::onPreferenceChange);
        this.preferenceProvider.initialize();
    }

    public SystemPreferencesManager() {
        this(true);
    }

    public ThemePreferenceProvider provider() {
        return this.preferenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPreferenceChange(PreferredThemeStyle preferredThemeStyle) {
        List<SystemPreferenceChangeListener> list = this.listenerList;
        synchronized (list) {
            new ArrayList<SystemPreferenceChangeListener>(this.listenerList).forEach(listener -> {
                if (listener != null) {
                    listener.onSystemPreferencesChanged(preferredThemeStyle);
                }
            });
        }
    }

    public void addListener(SystemPreferenceChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(SystemPreferenceChangeListener listener) {
        this.listenerList.add(listener);
    }

    private static ThemePreferenceProvider createProvider(boolean allowNativeReporting) {
        Object nativeProvider;
        try {
            nativeProvider = SystemInfo.isWindows10OrGreater && allowNativeReporting ? new WindowsThemePreferenceProvider() : (SystemInfo.isMac && allowNativeReporting ? new MacOSThemePreferenceProvider() : new DefaultThemePreferenceProvider());
        }
        catch (Throwable e) {
            nativeProvider = new DefaultThemePreferenceProvider();
        }
        return nativeProvider;
    }

    public void enableReporting(boolean reportingEnabled) {
        if (this.isReportingEnabled() != reportingEnabled) {
            this.preferenceProvider.setReporting(reportingEnabled);
            this.onPreferenceChange(this.getPreferredThemeStyle());
        }
    }

    public boolean isReportingEnabled() {
        return this.preferenceProvider.canReport() && this.preferenceProvider.isReporting();
    }

    public PreferredThemeStyle getPreferredThemeStyle() {
        return this.preferenceProvider.getPreference();
    }
}

