/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf;

import com.github.weisj.darklaf.icons.DarkUIAwareIcon;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.StateIcon;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.uiresource.DarkFontUIResource;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

public final class PropertyLoader {
    private static final Logger LOGGER = LogUtil.getLogger(PropertyLoader.class);
    private static final IconLoader ICON_LOADER = IconLoader.get(IconLoader.class);
    private static final char INT_LIST_START = '[';
    private static final char INT_LIST_END = ']';
    private static final String DUAL_KEY = "[dual]";
    private static final String AWARE_KEY = "[aware]";
    private static final String THEMED_KEY = "[themed]";
    private static final String ICON_EMPTY = "empty";
    private static final char REFERENCE_PREFIX = '%';
    private static final String FONT_FROM = "from";
    private static final String FONT_SIZE = "withSize";
    private static final String FONT_STYLE = "withStyle";
    private static final char FONT_DELIMITER = '-';
    private static final char LIST_START = '{';
    private static final char LIST_END = '}';
    private static final char ARG_START = '(';
    private static final char ARG_END = ')';
    private static final char SEPARATOR = ',';
    private static final char LIST_SEPARATOR = ';';
    private static final char PAIR_SEPARATOR = ':';
    private static boolean addReferenceInfo;
    private static final Map<AttributedCharacterIterator.Attribute, Integer> attributes;

    public static void setAddReferenceInfo(boolean addReferenceInfo) {
        PropertyLoader.addReferenceInfo = addReferenceInfo;
    }

    public static Properties loadProperties(Class<?> clazz, String name, String path) {
        Properties properties = new Properties();
        String p = path + name + ".properties";
        try (InputStream stream = clazz.getResourceAsStream(p);){
            properties.load(stream);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Could not load " + p + " " + e.getMessage(), e.getStackTrace());
        }
        return properties;
    }

    public static void putProperties(Properties properties, Properties accumulator, UIDefaults currentDefaults) {
        PropertyLoader.putProperties(properties, accumulator, currentDefaults, ICON_LOADER);
    }

    public static void putProperties(Properties properties, Properties accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        PropertyLoader.putProperties(properties, properties.stringPropertyNames(), accumulator, currentDefaults, iconLoader);
    }

    public static void putProperties(Properties properties, UIDefaults defaults) {
        PropertyLoader.putProperties(properties, defaults, ICON_LOADER);
    }

    public static void putProperties(Properties properties, UIDefaults defaults, IconLoader iconLoader) {
        PropertyLoader.putProperties(properties, properties.stringPropertyNames(), defaults, defaults, iconLoader);
    }

    public static void putProperties(Map<Object, Object> properties, Set<String> keys, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        for (String key : keys) {
            String value;
            Object parsed = PropertyLoader.parseValue(key, value = properties.get(key).toString(), accumulator, currentDefaults, iconLoader);
            if (parsed != null) {
                accumulator.put(PropertyLoader.parseKey(key), parsed);
                continue;
            }
            currentDefaults.remove(PropertyLoader.parseKey(key));
        }
    }

    public static void replaceProperties(Map<Object, Object> properties, Predicate<Map.Entry<Object, Object>> predicate, Function<Map.Entry<Object, Object>, Object> mapper) {
        PropertyLoader.replacePropertiesOfType(Object.class, properties, predicate, mapper);
    }

    public static <T> void replacePropertiesOfType(Class<T> type, Map<Object, Object> properties, Function<T, T> mapper) {
        PropertyLoader.replacePropertiesOfType(type, properties, e -> true, e -> mapper.apply(e.getValue()));
    }

    public static <T> void replacePropertiesOfType(Class<T> type, Map<Object, Object> properties, Predicate<Map.Entry<Object, T>> predicate, Function<Map.Entry<Object, T>, T> mapper) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            T newValue;
            if (type != Object.class && !type.isInstance(entry.getValue()) || !predicate.test(entry) || (newValue = mapper.apply(entry)) == null) continue;
            entry.setValue(newValue);
        }
    }

    private static String parseKey(String key) {
        if (addReferenceInfo) {
            return key;
        }
        return key.startsWith(String.valueOf('%')) ? key.substring(1) : key;
    }

    public static Object parseValue(String propertyKey, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        Boolean boolVal;
        if (value == null || "null".equals(value)) {
            return null;
        }
        String key = propertyKey;
        boolean skipObjects = false;
        if (key.startsWith(String.valueOf('%'))) {
            key = PropertyLoader.parseKey(key);
            skipObjects = true;
        }
        Color color = ColorUtil.fromHex((String)value, null);
        Integer invVal = PropertyLoader.getInteger(value);
        Boolean bl = "true".equalsIgnoreCase(value) ? Boolean.TRUE : (boolVal = "false".equalsIgnoreCase(value) ? Boolean.FALSE : null);
        if (color != null && (value.length() == 6 || value.length() == 8)) {
            return new DarkColorUIResource(color);
        }
        if (invVal != null) {
            return invVal;
        }
        if (boolVal != null) {
            return boolVal;
        }
        Object returnVal = new LoadError();
        if (key.endsWith("Insets") || key.endsWith(".insets")) {
            returnVal = PropertyLoader.parseInsets(value, accumulator, currentDefaults, iconLoader);
        } else {
            if (!skipObjects && (key.endsWith("Border") || key.endsWith(".border") || key.endsWith("Renderer"))) {
                return def -> PropertyLoader.parseObject(value);
            }
            if (key.endsWith(".component") || key.endsWith("Component")) {
                return def -> PropertyLoader.parseObject(value);
            }
            if (key.toLowerCase().endsWith("font")) {
                returnVal = PropertyLoader.parseFont(key, value, accumulator, currentDefaults);
            } else if (key.endsWith(".icon") || key.endsWith("Icon") || key.endsWith("Image")) {
                returnVal = PropertyLoader.parseIcon(value, accumulator, currentDefaults, iconLoader);
            } else if (key.endsWith("Size") || key.endsWith(".size")) {
                returnVal = PropertyLoader.parseSize(value);
            } else if (value.startsWith(String.valueOf('{')) && value.endsWith(String.valueOf('}'))) {
                returnVal = PropertyLoader.parseList((v, acc, defs, iconL) -> PropertyLoader.parseValue("", v, acc, defs, iconL), value, accumulator, currentDefaults, iconLoader);
            } else if (value.startsWith(String.valueOf('[')) && value.endsWith(String.valueOf(']'))) {
                returnVal = PropertyLoader.parseList(Integer::parseInt, value, accumulator, currentDefaults, iconLoader, '[', ']', ',');
            } else if (value.contains(String.valueOf(':'))) {
                returnVal = PropertyLoader.parsePair((v, acc, defs, iconL) -> PropertyLoader.parseValue("", v, acc, defs, iconL), value, accumulator, currentDefaults, iconLoader);
            } else if ("null".equalsIgnoreCase(value)) {
                returnVal = null;
            } else if (value.startsWith(String.valueOf('%'))) {
                returnVal = PropertyLoader.parseReference(key, value, accumulator, currentDefaults);
            }
        }
        if (!(returnVal instanceof LoadError)) {
            return returnVal;
        }
        return value;
    }

    private static <T> Pair<T, T> parsePair(ParseFunction<T> mapper, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        return PropertyLoader.parsePair(mapper, mapper, value, accumulator, currentDefaults, iconLoader);
    }

    private static <T, K> Pair<T, K> parsePair(ParseFunction<T> firstMapper, ParseFunction<K> secondMapper, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        String[] pairVals = value.split(String.valueOf(':'), 2);
        return new Pair(firstMapper.parseValue(pairVals[0], accumulator, currentDefaults, iconLoader), secondMapper.parseValue(pairVals[1], accumulator, currentDefaults, iconLoader));
    }

    private static Object parseReference(String key, String value, Map<Object, Object> accumulator, UIDefaults currentDefault) {
        Object returnVal;
        boolean defaultsContainKey;
        String val = PropertyLoader.parseKey(value);
        String referenceFreeKey = val.substring(1);
        boolean accumulatorContainsKey = accumulator.containsKey(val) || addReferenceInfo && accumulator.containsKey(referenceFreeKey);
        boolean bl = defaultsContainKey = currentDefault.containsKey(val) || addReferenceInfo && currentDefault.containsKey(referenceFreeKey);
        if (!defaultsContainKey && !accumulatorContainsKey) {
            LOGGER.warning("Could not reference value '" + val + "' while loading '" + key + "'. Maybe is a forward reference");
        }
        Object object = returnVal = accumulatorContainsKey ? accumulator.get(val) : currentDefault.get(val);
        if (addReferenceInfo) {
            if (returnVal == null) {
                returnVal = accumulatorContainsKey ? accumulator.get(referenceFreeKey) : currentDefault.get(val);
            }
            returnVal = new Pair((Object)value, returnVal);
        }
        return returnVal;
    }

    private static Object parseInsets(String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        List<Integer> insets = PropertyLoader.parseList(Integer::parseInt, value, accumulator, currentDefaults, iconLoader, '\u0000', '\u0000', ',');
        return new InsetsUIResource(insets.get(0), insets.get(1), insets.get(2), insets.get(3));
    }

    private static Object parseFont(String key, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults) {
        String val = value;
        Font base = null;
        int size = -1;
        int style = -1;
        while (true) {
            Object result;
            if (val.startsWith(FONT_FROM)) {
                result = PropertyLoader.parseFrom(val, accumulator, currentDefaults);
                base = (Font)result.getFirst();
                val = (String)result.getSecond();
                continue;
            }
            if (val.startsWith(FONT_SIZE)) {
                result = PropertyLoader.parseFontAttribute(FONT_SIZE, val, accumulator, currentDefaults);
                size = (Integer)result.getFirst();
                val = (String)result.getSecond();
                continue;
            }
            if (!val.startsWith(FONT_STYLE)) break;
            result = PropertyLoader.parseFontAttribute(FONT_STYLE, val, accumulator, currentDefaults);
            style = (Integer)result.getFirst();
            val = (String)result.getSecond();
        }
        if (base == null) {
            base = PropertyLoader.parseExplicitFont(value);
        }
        if (base == null && accumulator.get(key) instanceof Font) {
            base = (Font)accumulator.get(key);
        }
        if (base == null) {
            base = currentDefaults.getFont(key);
        }
        if (base == null) {
            base = new Font("Dialog", 0, 12);
        }
        if (size > 0) {
            base = base.deriveFont((float)size);
        }
        if (style >= 0) {
            base = base.deriveFont(style);
        }
        return new DarkFontUIResource(base.deriveFont(attributes));
    }

    private static Font parseExplicitFont(String value) {
        try {
            String[] decode = value.split(String.valueOf('-'));
            return new DarkFontUIResource(decode[0], Integer.parseInt(decode[1]), Integer.parseInt(decode[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Pair<Integer, String> parseFontAttribute(String identifier, String val, Map<Object, Object> accumulator, UIDefaults currrentDefault) {
        String key = val.substring(identifier.length() + 1);
        int lastIndex = key.indexOf(41);
        String rest = key.substring(lastIndex + 1);
        key = key.substring(0, lastIndex);
        String[] subKeys = key.split(String.valueOf(','));
        int[] values = new int[subKeys.length];
        for (int i = 0; i < values.length; ++i) {
            if (subKeys[i].startsWith(String.valueOf('%'))) {
                Object ref = PropertyLoader.parseReference(identifier, subKeys[i], accumulator, currrentDefault);
                values[i] = ref instanceof Integer ? (Integer)ref : 0;
                continue;
            }
            try {
                values[i] = Integer.parseInt(subKeys[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int result = 0;
        for (int i : values) {
            result += i;
        }
        return new Pair((Object)result, (Object)rest);
    }

    private static Pair<Font, String> parseFrom(String val, Map<Object, Object> accumulator, UIDefaults currentDefaults) {
        String key = val.substring(FONT_FROM.length() + 1);
        int index = key.indexOf(41);
        String rest = key.substring(index + 1);
        key = key.substring(0, index);
        Font font = null;
        if (accumulator.get(key) instanceof Font) {
            font = (Font)accumulator.get(key);
        }
        if (font == null) {
            font = currentDefaults.getFont(key);
        }
        return new Pair((Object)font, (Object)rest);
    }

    private static <T> List<T> parseList(ParseFunction<T> mapper, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        return PropertyLoader.parseList(mapper, value, accumulator, currentDefaults, iconLoader, '{', '}', ';');
    }

    private static <T> List<T> parseList(ParseFunction<T> mapper, String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader, char start, char end, char delimiter) {
        if (value == null || value.isEmpty()) {
            return new ArrayList();
        }
        String val = value;
        if (val.charAt(0) == start) {
            val = value.substring(1, value.length() - 1);
        }
        String[] values = val.split(String.valueOf(delimiter));
        return Arrays.stream(values).map(k -> mapper.parseValue((String)k, accumulator, currentDefaults, iconLoader)).collect(Collectors.toList());
    }

    private static Icon parseIcon(String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        if (value.startsWith(String.valueOf('{'))) {
            return PropertyLoader.parseStateIcon(value, accumulator, currentDefaults, iconLoader);
        }
        String path = value;
        Dimension dim = new Dimension(16, 16);
        if (value.charAt(value.length() - 1) == ')') {
            int i = path.lastIndexOf(40);
            String dimVal = path.substring(i + 1, path.length() - 1);
            int[] values = Arrays.stream(dimVal.split(String.valueOf(','), 2)).mapToInt(Integer::parseInt).toArray();
            dim.width = values[0];
            dim.height = values[1];
            path = path.substring(0, i);
        }
        if (path.charAt(path.length() - 1) == ']') {
            String tag = null;
            if (path.endsWith(DUAL_KEY)) {
                tag = DUAL_KEY;
            } else if (path.endsWith(AWARE_KEY)) {
                tag = AWARE_KEY;
            } else if (path.endsWith(THEMED_KEY)) {
                tag = THEMED_KEY;
            }
            if (tag == null) {
                throw new IllegalArgumentException("Invalid tag on icon path: '" + value + "'");
            }
            String iconPath = path.substring(0, path.length() - tag.length());
            if (tag.equals(THEMED_KEY)) {
                return iconLoader.getIcon(iconPath, dim.width, dim.height, true);
            }
            DarkUIAwareIcon icon = iconLoader.getUIAwareIcon(iconPath, dim.width, dim.height);
            if (tag.equals(DUAL_KEY)) {
                return icon.getDual();
            }
            return icon;
        }
        if (path.equals(ICON_EMPTY)) {
            return EmptyIcon.create(dim.width, dim.height);
        }
        return iconLoader.getIcon(path, dim.width, dim.height);
    }

    private static Icon parseStateIcon(String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
        return new StateIcon(PropertyLoader.parseList(PropertyLoader::parseIcon, value, accumulator, currentDefaults, iconLoader));
    }

    private static Object parseSize(String value) {
        try {
            int[] dim = Arrays.stream(value.split(String.valueOf(','), 2)).mapToInt(Integer::parseInt).toArray();
            return new DimensionUIResource(dim[0], dim[1]);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return new LoadError();
        }
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static Double getDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static Object parseObject(String value) {
        try {
            return Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        attributes = Collections.emptyMap();
    }

    private static interface SimpleValueMapper<T>
    extends ParseFunction<T> {
        public T map(String var1);

        @Override
        default public T parseValue(String value, Map<Object, Object> accumulator, UIDefaults currentDefaults, IconLoader iconLoader) {
            return this.map(value);
        }
    }

    private static interface ParseFunction<T> {
        public T parseValue(String var1, Map<Object, Object> var2, UIDefaults var3, IconLoader var4);
    }

    private static final class LoadError {
        private LoadError() {
        }
    }
}

