/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.color;

import com.github.weisj.darklaf.properties.color.DarkColorModel;
import com.github.weisj.darklaf.util.LazyValue;
import java.awt.Color;

public class DarkColorModelRGB
extends DarkColorModel {
    private static final LazyValue<DarkColorModelRGB> instance = new LazyValue(DarkColorModelRGB::new);

    public static DarkColorModelRGB getInstance() {
        return (DarkColorModelRGB)instance.get();
    }

    public DarkColorModelRGB() {
        super("rgb", "Red", "Green", "Blue");
    }

    @Override
    public int getMinimum(int index) {
        return 0;
    }

    @Override
    public int getMaximum(int index) {
        return 255;
    }

    @Override
    public String toString() {
        return "RGB";
    }

    @Override
    public String[] getLabelDescriptorsBefore() {
        return new String[]{"R", "G", "B"};
    }

    @Override
    public String[] getLabelDescriptorsAfter() {
        return new String[]{"", "", "", ""};
    }

    @Override
    public int[] getValuesFromColor(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public int[] getValuesFromColorWithAlpha(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
    }

    @Override
    public Color getColorFromValues(int[] values) {
        return new Color(values[0], values[1], values[2]);
    }
}

