/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.parser.ParseResult;
import com.github.weisj.darklaf.properties.parser.Parser;
import com.github.weisj.darklaf.properties.parser.ParserContext;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.Types;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public final class IconColorMapper {
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final String INLINE_VALUE_PREFIX = "%";
    private static final Color FALLBACK_COLOR = Color.RED;

    public static Color resolveColor(String key, String[] fallbacks, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        Color color = IconColorMapper.get(propertyMap, contextDefaults, key, fallbacks, Color.class);
        if (color == null) {
            color = FALLBACK_COLOR;
            LOGGER.warning("Could not load color with id '" + key + "' fallbacks" + Arrays.toString(fallbacks) + ". Using color '" + color + "' instead.");
        }
        return color;
    }

    public static float getOpacity(String key, String[] fallbacks, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        if (!(key != null && !key.isEmpty() || fallbacks != null && fallbacks.length != 0)) {
            return -1.0f;
        }
        Number obj = IconColorMapper.get(propertyMap, contextDefaults, key, fallbacks, Number.class);
        if (obj instanceof Integer) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Long) {
            return (float)obj.intValue() / 100.0f;
        }
        if (obj instanceof Float) {
            return obj.floatValue();
        }
        if (obj instanceof Double) {
            return obj.floatValue();
        }
        LOGGER.warning(obj + " is an invalid opacity value. Key = '" + key + "'");
        return -1.0f;
    }

    public static <T> Pair<Object, T> getEntry(Map<Object, Object> map, Map<Object, Object> contextDefaults, Object key, Object[] fallbacks, Class<T> type) {
        Object obj = null;
        String refPrefix = PropertyLoader.getReferencePrefix();
        HashSet<Object> seen = new HashSet<Object>();
        Object currentKey = key;
        int max = fallbacks != null ? fallbacks.length : 0;
        block0: for (int i = -1; i < max; ++i) {
            currentKey = i < 0 ? key : fallbacks[i];
            int retryCount = 5;
            if (i >= 0 && currentKey instanceof String && ((String)currentKey).startsWith(INLINE_VALUE_PREFIX)) {
                ParseResult p = Parser.parse(Parser.createParseResult(Objects.toString(key), ((String)currentKey).substring(INLINE_VALUE_PREFIX.length())), new ParserContext(map, contextDefaults, IconLoader.get()));
                obj = Types.safeCast((Object)p.result, type);
            }
            do {
                if (obj == null) {
                    obj = map.get(currentKey);
                }
                if (contextDefaults != null && (obj == null || seen.contains(obj))) {
                    obj = contextDefaults.get(currentKey);
                }
                seen.add(obj);
                if (!(obj instanceof String) || !obj.toString().startsWith(refPrefix)) {
                    if (!type.isInstance(obj)) continue block0;
                    break block0;
                }
                currentKey = obj.toString().substring(refPrefix.length());
                obj = null;
            } while (--retryCount > 0);
        }
        return new Pair(currentKey, type.cast(obj));
    }

    public static <T> T get(Map<Object, Object> map, Map<Object, Object> contextDefaults, Object key, Object[] fallbacks, Class<T> type) {
        return (T)IconColorMapper.getEntry(map, contextDefaults, key, fallbacks, type).getSecond();
    }
}

