/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.DarkSVGIconDomProcessor;
import com.github.weisj.darklaf.properties.icons.IconColorMapper;
import com.github.weisj.darklaf.properties.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.jsvg.attributes.paint.DefaultPaintParser;
import com.github.weisj.jsvg.attributes.paint.SimplePaintSVGPaint;
import com.github.weisj.jsvg.nodes.Defs;
import com.github.weisj.jsvg.nodes.LinearGradient;
import com.github.weisj.jsvg.nodes.SolidColor;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.DefaultParserProvider;
import com.github.weisj.jsvg.parser.DomProcessor;
import com.github.weisj.jsvg.parser.ParsedElement;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemedSVGIconParserProvider
extends DefaultParserProvider {
    private final DomProcessor preProcessor;

    public ThemedSVGIconParserProvider(@NotNull ThemedSVGIcon icon) {
        this.preProcessor = new ThemedSVGIconDomProcessor(icon);
    }

    @Nullable
    public DomProcessor createPreProcessor() {
        return this.preProcessor;
    }

    public static void patchColors(List<ThemedSolidColorPaint> paints, Map<Object, Object> propertyMap, Map<Object, Object> contextDefaults) {
        for (ThemedSolidColorPaint paint : paints) {
            paint.color = IconColorMapper.resolveColor(paint.colorKey, paint.colorFallbacks, propertyMap, contextDefaults);
            float opacity = IconColorMapper.getOpacity(paint.opacityKey, paint.opacityFallbacks, propertyMap, contextDefaults);
            if (opacity < 0.0f) {
                opacity = paint.originalOpacity;
            }
            paint.color = ColorUtil.toAlpha((Color)paint.color, (double)opacity);
        }
    }

    public static Map<Object, Object> getProperties(List<ThemedSolidColorPaint> paints) {
        HashMap<Object, Object> values = new HashMap<Object, Object>(paints.size() * 2, 0.75f);
        for (ThemedSolidColorPaint paint : paints) {
            values.put(paint.colorKey, ColorUtil.removeAlpha((Color)paint.color));
            if (paint.opacityKey == null || paint.opacityKey.isEmpty()) continue;
            values.put(paint.opacityKey, (int)((float)paint.color.getAlpha() / 255.0f));
        }
        return values;
    }

    public static Map<String, Color> getNamedColors(ThemedSVGIcon icon) {
        icon.ensureLoaded(false);
        return icon.paints().stream().collect(Collectors.toMap(p -> ((ThemedSolidColorPaint)p).colorKey, p -> ((ThemedSolidColorPaint)p).color));
    }

    private static class ThemedSVGIconDomProcessor
    extends DarkSVGIconDomProcessor<ThemedSVGIcon> {
        public ThemedSVGIconDomProcessor(@NotNull ThemedSVGIcon icon) {
            super(icon);
        }

        @Override
        public void process(@NotNull ParsedElement root) {
            super.process(root);
            for (ParsedElement child : root.children()) {
                if (!"colors".equals(child.id()) || !(child.node() instanceof Defs)) continue;
                this.replaceColorDefinitions(child);
                return;
            }
        }

        private void replaceColorDefinitions(ParsedElement element) {
            for (ParsedElement child : element.children()) {
                if (child.node() instanceof LinearGradient || child.node() instanceof SolidColor) {
                    this.replaceGradientColor(child, "opacity");
                    continue;
                }
                if (!(child.node() instanceof SolidColor)) continue;
                this.replaceGradientColor(child, "solid-opacity");
            }
        }

        private void replaceGradientColor(ParsedElement colorElement, String opacityTag) {
            String id = colorElement.id();
            if (id == null) {
                return;
            }
            AttributeNode attributeNode = colorElement.attributeNode();
            String[] fallbacks = attributeNode.getStringList("fallback");
            String opacityKey = attributeNode.getValue(opacityTag);
            String[] opacityFallback = attributeNode.getStringList("opacity-fallback");
            List stops = colorElement.children();
            float originalOpacity = 1.0f;
            if (!stops.isEmpty()) {
                originalOpacity = ((ParsedElement)stops.get(0)).attributeNode().getPercentage("stop-opacity", originalOpacity);
            }
            ThemedSolidColorPaint themedPaint = new ThemedSolidColorPaint(id, fallbacks, opacityKey, opacityFallback, originalOpacity);
            colorElement.registerNamedElement(id, (Object)themedPaint);
            ((ThemedSVGIcon)this.icon).registerPaint(themedPaint);
        }
    }

    static class ThemedSolidColorPaint
    implements SimplePaintSVGPaint {
        private final String colorKey;
        private final String[] colorFallbacks;
        private final String opacityKey;
        private final String[] opacityFallbacks;
        private final float originalOpacity;
        private Color color = DefaultPaintParser.DEFAULT_COLOR;

        ThemedSolidColorPaint(String colorKey, String[] colorFallbacks, String opacityKey, String[] opacityFallbacks, float originalOpacity) {
            this.colorKey = colorKey;
            this.colorFallbacks = colorFallbacks;
            this.opacityKey = opacityKey;
            this.opacityFallbacks = opacityFallbacks;
            this.originalOpacity = originalOpacity;
        }

        @NotNull
        public Paint paint() {
            return this.color;
        }
    }
}

