/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.theme.ThemeDelegate;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.ColorToneRule;
import com.github.weisj.darklaf.theme.info.ContrastRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PresetIconRule;
import com.github.weisj.darklaf.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.text.html.StyleSheet;

public abstract class Theme
implements Comparable<Theme>,
Comparator<Theme> {
    private static final Logger LOGGER = LogUtil.getLogger(Theme.class);
    private final FontSizeRule fontSizeRule;
    private final AccentColorRule accentColorRule;

    public Theme() {
        this(null, null);
    }

    public Theme(FontSizeRule fontSizeRule, AccentColorRule accentColorRule) {
        this.fontSizeRule = fontSizeRule != null ? fontSizeRule : FontSizeRule.getDefault();
        this.accentColorRule = accentColorRule != null ? accentColorRule : AccentColorRule.getDefault();
    }

    public Theme derive(FontSizeRule fontSizeRule, AccentColorRule accentColorRule) {
        return new ThemeDelegate(this, fontSizeRule, accentColorRule);
    }

    public Theme copy() {
        return new ThemeDelegate(this);
    }

    public static boolean isDark(Theme theme) {
        if (theme == null) {
            return false;
        }
        return theme.getColorToneRule() == ColorToneRule.DARK;
    }

    public static boolean isHighContrast(Theme theme) {
        if (theme == null) {
            return false;
        }
        return theme.getContrastRule() == ContrastRule.HIGH_CONTRAST;
    }

    public void loadDefaults(Properties properties, UIDefaults currentDefaults) {
        PropertyLoader.putProperties((Properties)this.loadPropertyFile("defaults"), (Properties)properties, (UIDefaults)currentDefaults);
    }

    public void customizeGlobals(Properties properties, UIDefaults currentDefaults) {
    }

    public void customizeIconTheme(Properties properties, UIDefaults currentDefaults) {
    }

    public void loadIconTheme(Properties properties, UIDefaults currentDefaults) {
        Properties props;
        PresetIconRule iconTheme = this.getPresetIconRule();
        switch (iconTheme) {
            case DARK: {
                props = PropertyLoader.loadProperties(Theme.class, (String)"dark_icons", (String)"icon_presets/");
                break;
            }
            case LIGHT: {
                props = PropertyLoader.loadProperties(Theme.class, (String)"light_icons", (String)"icon_presets/");
                break;
            }
            default: {
                props = this.loadPropertyFile("icons");
            }
        }
        PropertyLoader.putProperties((Properties)props, (Properties)properties, (UIDefaults)currentDefaults);
    }

    public void customizePlatformProperties(Properties properties, UIDefaults currentDefaults) {
    }

    public void customizeUIProperties(Properties properties, UIDefaults currentDefaults) {
    }

    protected abstract PresetIconRule getPresetIconRule();

    protected final void loadCustomProperties(String propertySuffix, Properties properties, UIDefaults currentDefaults) {
        PropertyLoader.putProperties((Properties)this.loadPropertyFile(propertySuffix), (Properties)properties, (UIDefaults)currentDefaults);
    }

    public Properties loadAccentProperties() {
        return this.loadPropertyFile("accents", true);
    }

    protected final Properties load(String name) {
        return this.loadWithClass(name, this.getLoaderClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Properties loadWithClass(String name, Class<?> loaderClass) {
        Properties properties = new Properties();
        try (InputStream stream = loaderClass.getResourceAsStream(name);){
            if (stream == null) {
                LOGGER.log(Level.SEVERE, "Could not load " + name + ".properties. File not found");
                Properties properties2 = properties;
                return properties2;
            }
            properties.load(stream);
            return properties;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not load " + name + ".properties. " + e.getMessage(), e.getStackTrace());
        }
        return properties;
    }

    public final StyleSheet loadStyleSheet() {
        return this.loadStyleSheetWithClass(this.getLoaderClass());
    }

    public final StyleSheet loadStyleSheetWithClass(Class<?> loaderClass) {
        StyleSheet styleSheet = new StyleSheet();
        try (InputStream in = loaderClass.getResourceAsStream(this.getResourcePath() + this.getPrefix() + "_styleSheet.css");
             InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader r = new BufferedReader(inReader);){
            styleSheet.loadRules(r, null);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e.getStackTrace());
        }
        return styleSheet;
    }

    public String toString() {
        return this.getName();
    }

    protected String getResourcePath() {
        return "";
    }

    public abstract String getPrefix();

    public abstract String getName();

    protected abstract Class<? extends Theme> getLoaderClass();

    protected String getPropertyFilePath(String name) {
        return this.getResourcePath() + this.getPrefix() + "_" + name + ".properties";
    }

    public final Properties loadPropertyFile(String name) {
        return this.loadPropertyFile(name, false);
    }

    public final Properties loadPropertyFile(String name, boolean silent) {
        Level level = LOGGER.getLevel();
        if (silent) {
            LOGGER.setLevel(Level.OFF);
        }
        Properties properties = this.load(this.getPropertyFilePath(name));
        LOGGER.setLevel(level);
        return properties;
    }

    public boolean useCustomDecorations() {
        return true;
    }

    public boolean supportsCustomAccentColor() {
        return false;
    }

    public boolean supportsCustomSelectionColor() {
        return false;
    }

    public abstract ColorToneRule getColorToneRule();

    public ContrastRule getContrastRule() {
        return ContrastRule.STANDARD;
    }

    public FontSizeRule getFontSizeRule() {
        return this.fontSizeRule;
    }

    public AccentColorRule getAccentColorRule() {
        return this.accentColorRule;
    }

    @Override
    public int compareTo(Theme o) {
        if (o == null) {
            return 1;
        }
        int stringComp = this.getName().compareTo(o.getName());
        int contrastCompare = Boolean.compare(Theme.isHighContrast(this), Theme.isHighContrast(o));
        int toneCompare = Boolean.compare(Theme.isDark(this), Theme.isDark(o));
        if (contrastCompare != 0) {
            return contrastCompare;
        }
        if (toneCompare != 0) {
            return toneCompare;
        }
        return stringComp;
    }

    @Override
    public int compare(Theme o1, Theme o2) {
        if (o1 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public Class<? extends Theme> getThemeClass() {
        return this.getClass();
    }

    public boolean appearsEqualTo(Theme theme) {
        if (theme == null) {
            return false;
        }
        if (!Objects.equals(this.getThemeClass(), theme.getThemeClass())) {
            return false;
        }
        return Objects.equals(this.getAccentColorRule(), theme.getAccentColorRule()) && Objects.equals((Object)this.getColorToneRule(), (Object)theme.getColorToneRule()) && Objects.equals((Object)this.getContrastRule(), (Object)theme.getContrastRule()) && Objects.equals(this.getFontSizeRule(), theme.getFontSizeRule());
    }
}

