/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.ColorToneRule;
import com.github.weisj.darklaf.theme.info.ContrastRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PresetIconRule;
import java.util.Properties;
import javax.swing.UIDefaults;

public class ThemeDelegate
extends Theme {
    private final Theme delegate;
    private final boolean overwriteFontSize;
    private final boolean overWriteAccentColor;

    public ThemeDelegate(Theme delegate) {
        this(delegate, null, null);
    }

    public ThemeDelegate(Theme delegate, FontSizeRule fontSizeRule, AccentColorRule accentColorRule) {
        super(fontSizeRule, accentColorRule);
        if (delegate == null) {
            throw new IllegalArgumentException("Theme delegate cannot be null");
        }
        this.delegate = delegate;
        this.overwriteFontSize = fontSizeRule != null;
        this.overWriteAccentColor = accentColorRule != null;
    }

    public Theme getDelegate() {
        return this.delegate;
    }

    @Override
    public Class<? extends Theme> getThemeClass() {
        return this.delegate.getThemeClass();
    }

    @Override
    public boolean appearsEqualTo(Theme theme) {
        if (this.overwriteFontSize || this.overWriteAccentColor) {
            return super.appearsEqualTo(theme);
        }
        return this.getDelegate().appearsEqualTo(theme);
    }

    @Override
    public Theme derive(FontSizeRule fontSizeRule, AccentColorRule accentColorRule) {
        return this.getDelegate().derive(fontSizeRule, accentColorRule);
    }

    @Override
    public Theme copy() {
        return this.getDelegate().copy();
    }

    @Override
    public FontSizeRule getFontSizeRule() {
        return this.overwriteFontSize ? super.getFontSizeRule() : this.getDelegate().getFontSizeRule();
    }

    @Override
    public AccentColorRule getAccentColorRule() {
        return this.overWriteAccentColor ? super.getAccentColorRule() : this.getDelegate().getAccentColorRule();
    }

    @Override
    public ColorToneRule getColorToneRule() {
        return this.getDelegate().getColorToneRule();
    }

    @Override
    public ContrastRule getContrastRule() {
        return this.getDelegate().getContrastRule();
    }

    @Override
    protected PresetIconRule getPresetIconRule() {
        return this.getDelegate().getPresetIconRule();
    }

    @Override
    public void loadDefaults(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().loadDefaults(properties, currentDefaults);
    }

    @Override
    public void customizeGlobals(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().customizeGlobals(properties, currentDefaults);
    }

    @Override
    public void customizeIconTheme(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().customizeIconTheme(properties, currentDefaults);
    }

    @Override
    public void loadIconTheme(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().loadIconTheme(properties, currentDefaults);
    }

    @Override
    public void customizePlatformProperties(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().customizePlatformProperties(properties, currentDefaults);
    }

    @Override
    public void customizeUIProperties(Properties properties, UIDefaults currentDefaults) {
        this.getDelegate().customizeUIProperties(properties, currentDefaults);
    }

    @Override
    public String toString() {
        return this.getDelegate().getName();
    }

    @Override
    protected String getResourcePath() {
        return this.getDelegate().getResourcePath();
    }

    @Override
    public String getPrefix() {
        return this.getDelegate().getPrefix();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    protected Class<? extends Theme> getLoaderClass() {
        return this.getDelegate().getClass();
    }

    @Override
    protected String getPropertyFilePath(String name) {
        return this.getDelegate().getPropertyFilePath(name);
    }

    @Override
    public boolean useCustomDecorations() {
        return this.getDelegate().useCustomDecorations();
    }

    @Override
    public boolean supportsCustomSelectionColor() {
        return this.getDelegate().supportsCustomSelectionColor();
    }

    @Override
    public boolean supportsCustomAccentColor() {
        return this.getDelegate().supportsCustomAccentColor();
    }
}

