/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.PresetIconRule;
import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.ColorToneRule;
import com.github.weisj.darklaf.theme.spec.ContrastRule;
import com.github.weisj.darklaf.theme.spec.FontPrototype;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import java.util.Properties;
import javax.swing.UIDefaults;

public class ThemeDelegate
extends Theme {
    private final Theme delegate;
    private final boolean overwriteFontSize;
    private final boolean overwriteFontPrototype;
    private final boolean overwriteAccentColor;

    public ThemeDelegate(Theme delegate) {
        this(delegate, null, null, null);
    }

    public ThemeDelegate(Theme delegate, FontSizeRule fontSizeRule, FontPrototype fontPrototype, AccentColorRule accentColorRule) {
        super(fontSizeRule, fontPrototype, accentColorRule);
        if (delegate == null) {
            throw new IllegalArgumentException("Theme delegate cannot be null");
        }
        this.delegate = delegate;
        this.overwriteFontSize = fontSizeRule != null;
        this.overwriteFontPrototype = fontPrototype != null;
        this.overwriteAccentColor = accentColorRule != null;
    }

    public Theme getDelegate() {
        return this.delegate;
    }

    @Override
    public Class<? extends Theme> getThemeClass() {
        return this.delegate.getThemeClass();
    }

    @Override
    public boolean appearsEqualTo(Theme theme) {
        if (this.overwriteFontSize || this.overwriteAccentColor || this.overwriteFontPrototype) {
            return super.appearsEqualTo(theme);
        }
        return this.getDelegate().appearsEqualTo(theme);
    }

    @Override
    public Theme derive(FontSizeRule fontSizeRule, FontPrototype fontPrototype, AccentColorRule accentColorRule) {
        return this.getDelegate().derive(fontSizeRule, fontPrototype, accentColorRule);
    }

    @Override
    public Theme copy() {
        return this.getDelegate().copy();
    }

    @Override
    public FontSizeRule getFontSizeRule() {
        return this.overwriteFontSize ? super.getFontSizeRule() : this.getDelegate().getFontSizeRule();
    }

    @Override
    public AccentColorRule getAccentColorRule() {
        return this.overwriteAccentColor ? super.getAccentColorRule() : this.getDelegate().getAccentColorRule();
    }

    @Override
    public FontPrototype getFontPrototype() {
        return this.overwriteFontPrototype ? super.getFontPrototype() : this.getDelegate().getFontPrototype();
    }

    @Override
    public ColorToneRule getColorToneRule() {
        return this.getDelegate().getColorToneRule();
    }

    @Override
    public ContrastRule getContrastRule() {
        return this.getDelegate().getContrastRule();
    }

    @Override
    protected PresetIconRule getPresetIconRule() {
        return this.getDelegate().getPresetIconRule();
    }

    @Override
    public void loadDefaults(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().loadDefaults(properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizeGlobals(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().customizeGlobals(properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizeIconTheme(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().customizeIconTheme(properties, currentDefaults, iconResolver);
    }

    @Override
    public void loadIconTheme(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().loadIconTheme(properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizePlatformProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().customizePlatformProperties(properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizeUIProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        this.getDelegate().customizeUIProperties(properties, currentDefaults, iconResolver);
    }

    @Override
    protected String getResourcePath() {
        return this.getDelegate().getResourcePath();
    }

    @Override
    public String getPrefix() {
        return this.getDelegate().getPrefix();
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public String getDisplayName() {
        return this.getDelegate().getDisplayName();
    }

    @Override
    protected Class<? extends Theme> getLoaderClass() {
        return this.getDelegate().getClass();
    }

    @Override
    protected String getPropertyFilePath(String name) {
        return this.getDelegate().getPropertyFilePath(name);
    }

    @Override
    public boolean useCustomDecorations() {
        return this.getDelegate().useCustomDecorations();
    }

    @Override
    public boolean supportsCustomSelectionColor() {
        return this.getDelegate().supportsCustomSelectionColor();
    }

    @Override
    public boolean supportsCustomAccentColor() {
        return this.getDelegate().supportsCustomAccentColor();
    }
}

