/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.Alignment;
import java.awt.Insets;

public enum AlignmentExt {
    NORTH(Alignment.NORTH),
    SOUTH(Alignment.SOUTH_WEST),
    EAST(Alignment.EAST),
    WEST(Alignment.WEST),
    NORTH_EAST(Alignment.NORTH_EAST),
    NORTH_WEST(Alignment.NORTH_WEST),
    SOUTH_EAST(Alignment.SOUTH_EAST),
    SOUTH_WEST(Alignment.SOUTH_WEST),
    CENTER(Alignment.CENTER),
    LEFT(null),
    MIDDLE_HORIZONTAL(null),
    RIGHT(null),
    TOP(null),
    MIDDLE_VERTICAL(null),
    BOTTOM(null);

    private Alignment parent;

    private AlignmentExt(Alignment parent) {
        this.parent = parent;
    }

    public Insets maskInsets(Insets insets) {
        return this.maskInsets(insets, 0);
    }

    public Insets maskInsets(Insets insets, int maskValue) {
        return this.maskInsets(insets.top, insets.left, insets.bottom, insets.right, maskValue);
    }

    public Insets maskInsets(int top, int left, int bottom, int right, int mask) {
        switch (this) {
            case NORTH: 
            case NORTH_EAST: 
            case EAST: 
            case SOUTH_EAST: 
            case SOUTH: 
            case SOUTH_WEST: 
            case WEST: 
            case NORTH_WEST: 
            case CENTER: {
                return this.parent.maskInsets(top, left, bottom, right, mask);
            }
            case LEFT: {
                return new Insets(top, left, bottom, mask);
            }
            case MIDDLE_HORIZONTAL: {
                return new Insets(top, mask, bottom, mask);
            }
            case RIGHT: {
                return new Insets(top, mask, bottom, right);
            }
            case TOP: {
                return new Insets(top, left, mask, right);
            }
            case MIDDLE_VERTICAL: {
                return new Insets(mask, left, mask, right);
            }
            case BOTTOM: {
                return new Insets(mask, left, bottom, right);
            }
        }
        throw new IllegalArgumentException();
    }

    public Insets maskInsetsInverted(Insets insets) {
        return this.maskInsetsInverted(insets, 0);
    }

    public Insets maskInsetsInverted(Insets insets, int mask) {
        return this.maskInsetsInverted(insets.top, insets.left, insets.bottom, insets.right, mask);
    }

    public Insets maskInsetsInverted(int top, int left, int bottom, int right, int mask) {
        Insets masking = this.maskInsets(0, 0, 0, 0, 1);
        Insets maskVal = this.maskInsets(mask, mask, mask, mask, 0);
        return new Insets(top * masking.top + maskVal.top, left * masking.left + maskVal.left, bottom * masking.bottom + maskVal.bottom, right * masking.right + maskVal.right);
    }
}

