/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class StringUtil {
    private StringUtil() {
    }

    public static String toUpperCase(String a) {
        return a == null ? null : StringUtil.toUpperCase((CharSequence)a).toString();
    }

    public static CharSequence toUpperCase(CharSequence s) {
        if (s == null) {
            throw new NullPointerException("CharSequence can't be null");
        }
        if (s.length() == 0) {
            return s;
        }
        StringBuilder answer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char upCased = StringUtil.toUpperCase(c);
            answer.append(upCased);
        }
        return answer;
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        return a <= 'z' ? (char)(a + -32) : Character.toUpperCase(a);
    }

    public static List<String> split(String s, String separator) {
        return StringUtil.split(s, separator, true);
    }

    public static List<String> split(String s, String separator, boolean excludeSeparator) {
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    public static List<String> split(String s, String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (separator.isEmpty()) {
            return Collections.singletonList(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (true) {
            int index;
            if ((index = s.indexOf(separator, pos)) == -1) {
                if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
                    result.add(s.substring(pos));
                }
                return result;
            }
            int nextPos = index + separator.length();
            String token = s.substring(pos, excludeSeparator ? index : nextPos);
            if (!token.isEmpty() || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
    }

    public static int indexOfIgnoreCase(String where, char what, int fromIndex) {
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtil.toUpperCase(a) == StringUtil.toUpperCase(b) || StringUtil.toLowerCase(a) == StringUtil.toLowerCase(b);
    }

    public static char toLowerCase(char a) {
        if (a >= 'A' && (a < 'a' || a > 'z')) {
            return a <= 'Z' ? (char)(a + 32) : Character.toLowerCase(a);
        }
        return a;
    }

    public static boolean containsIgnoreCase(String where, String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static int indexOfIgnoreCase(String where, String what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean isBlank(String s) {
        return s.trim().length() == 0;
    }

    public static String repeat(String s, int count) {
        if (count <= 0) {
            return "";
        }
        if (count == 1) {
            return s;
        }
        StringBuilder builder = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            builder.append(s);
        }
        return builder.toString();
    }
}

