/*
 * MIT License
 *
 * Copyright (c) 2021 Jannis Weis
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */
package com.github.weisj.darklaf.util;

import javax.swing.*;

public final class PropertyKey {
    public static final String UI = "UI";
    public static final String COMPONENT_ORIENTATION = "componentOrientation";
    public static final String LAYOUT_ORIENTATION = "layoutOrientation";
    public static final String ORIENTATION = "orientation";
    public static final String VALUE = "value";
    public static final String HTML = "html";
    public static final String COMPONENT = "component";
    public static final String OPAQUE = "opaque";
    public static final String ANCESTOR = "ancestor";
    public static final String EDITABLE = "editable";
    public static final String ENABLED = "enabled";
    public static final String BACKGROUND = "background";
    public static final String FOREGROUND = "foreground";
    public static final String FONT = "font";
    public static final String DOCUMENT = "document";
    public static final String PAINTING_FOR_PRINT = "paintingForPrint";
    public static final String CARET = "caret";
    public static final String WINDOW_DECORATIONS_STYLE = "windowDecorationStyle";
    public static final String COMPONENT_POPUP_MENU = "componentPopupMenu";
    public static final String TITLE = "title";
    public static final String VISIBLE = "visible";
    public static final String FOCUSABLE = "focusable";
    public static final String ROLLOVER = AbstractButton.ROLLOVER_ENABLED_CHANGED_PROPERTY;
    public static final String LAF = "lookAndFeel";
    public static final String GRAPHICS_CONFIGURATION = "graphicsConfiguration";
    public static final String BORDER = "border";
}
