/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.AlignmentHelper;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public enum Alignment {
    NORTH(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    SOUTH(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE)),
    WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE)),
    NORTH_EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    NORTH_WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_TOP_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_TOP_OUTSIDE)),
    SOUTH_EAST(AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_RIGHT_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    SOUTH_WEST(AlignmentHelper.align(AlignmentHelper.HOR_LEFT_INSIDE, AlignmentHelper.VERT_BOTTOM_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_LEFT_OUTSIDE, AlignmentHelper.VERT_BOTTOM_OUTSIDE)),
    CENTER(AlignmentHelper.align(AlignmentHelper.HOR_CENTER_INSIDE, AlignmentHelper.VERT_CENTER_INSIDE), AlignmentHelper.align(AlignmentHelper.HOR_CENTER_OUTSIDE, AlignmentHelper.VERT_CENTER_OUTSIDE));

    private final AlignmentHelper.AlignFunction alignInside;
    private final AlignmentHelper.AlignFunction alignOutside;

    private Alignment(AlignmentHelper.AlignFunction alignInside, AlignmentHelper.AlignFunction alignOutside) {
        this.alignInside = alignInside;
        this.alignOutside = alignOutside;
    }

    public static Alignment getAlignment(Point point, Dimension size, Rectangle outerBounds, Alignment hint) {
        if (hint.canBeAligned(point, size, outerBounds)) {
            return hint;
        }
        for (Alignment alignment : Alignment.values()) {
            if (alignment == CENTER || alignment == hint || !alignment.canBeAligned(point, size, outerBounds)) continue;
            return alignment;
        }
        return CENTER;
    }

    public boolean canBeAligned(Point point, Dimension size, Rectangle outerBounds) {
        Point p = this.relativePos(size, point);
        return p.x >= outerBounds.x && p.y >= outerBounds.y && p.x + size.width < outerBounds.x + outerBounds.width && p.y + size.height < outerBounds.x + outerBounds.height;
    }

    public Point relativePos(Dimension toAlign, Point alignAt) {
        return this.alignOutside(toAlign, new Rectangle(alignAt.x, alignAt.y, 0, 0));
    }

    public Point alignOutside(Dimension toAlign, Rectangle innerBounds) {
        return (Point)this.alignOutside.apply(toAlign, innerBounds);
    }

    public int getIndex() {
        return this.ordinal();
    }

    public Alignment opposite() {
        return switch (this) {
            case NORTH -> SOUTH;
            case NORTH_EAST -> SOUTH_WEST;
            case EAST -> WEST;
            case SOUTH_EAST -> NORTH_WEST;
            case SOUTH -> NORTH;
            case SOUTH_WEST -> NORTH_EAST;
            case WEST -> EAST;
            case NORTH_WEST -> SOUTH_EAST;
            case CENTER -> CENTER;
            default -> throw new IllegalArgumentException();
        };
    }

    public Alignment anticlockwise() {
        return switch (this) {
            case NORTH -> NORTH_WEST;
            case NORTH_EAST -> NORTH;
            case EAST -> NORTH_EAST;
            case SOUTH_EAST -> EAST;
            case SOUTH -> SOUTH_EAST;
            case SOUTH_WEST -> SOUTH;
            case WEST -> SOUTH_WEST;
            case NORTH_WEST -> WEST;
            case CENTER -> CENTER;
            default -> throw new IllegalArgumentException();
        };
    }

    public Alignment clockwise() {
        return switch (this) {
            case NORTH -> NORTH_EAST;
            case NORTH_EAST -> EAST;
            case EAST -> SOUTH_EAST;
            case SOUTH_EAST -> SOUTH;
            case SOUTH -> SOUTH_WEST;
            case SOUTH_WEST -> WEST;
            case WEST -> NORTH_WEST;
            case NORTH_WEST -> NORTH;
            case CENTER -> CENTER;
            default -> throw new IllegalArgumentException();
        };
    }

    public Insets maskInsets(Insets insets) {
        return this.maskInsets(insets, 0);
    }

    public Insets maskInsets(Insets insets, int maskValue) {
        return this.maskInsets(insets.top, insets.left, insets.bottom, insets.right, maskValue);
    }

    public Insets maskInsets(int top, int left, int bottom, int right, int mask) {
        return switch (this) {
            case NORTH -> new Insets(top, mask, mask, mask);
            case NORTH_EAST -> new Insets(top, mask, mask, right);
            case EAST -> new Insets(mask, mask, mask, right);
            case SOUTH_EAST -> new Insets(mask, mask, bottom, right);
            case SOUTH -> new Insets(mask, mask, bottom, mask);
            case SOUTH_WEST -> new Insets(mask, left, bottom, mask);
            case WEST -> new Insets(mask, left, mask, mask);
            case NORTH_WEST -> new Insets(top, left, mask, mask);
            case CENTER -> new Insets(mask, mask, mask, mask);
            default -> throw new IllegalArgumentException();
        };
    }

    public Insets maskInsetsInverted(Insets insets) {
        return this.maskInsetsInverted(insets, 0);
    }

    public Insets maskInsetsInverted(Insets insets, int mask) {
        return this.maskInsetsInverted(insets.top, insets.left, insets.bottom, insets.right, mask);
    }

    public Insets maskInsetsInverted(int top, int left, int bottom, int right, int mask) {
        Insets masking = this.maskInsets(0, 0, 0, 0, 1);
        Insets maskVal = this.maskInsets(mask, mask, mask, mask, 0);
        return new Insets(top * masking.top + maskVal.top, left * masking.left + maskVal.left, bottom * masking.bottom + maskVal.bottom, right * masking.right + maskVal.right);
    }

    public Point alignInside(Dimension toAlign, Rectangle outerBounds) {
        return (Point)this.alignInside.apply(toAlign, outerBounds);
    }

    public boolean isNorth() {
        return this == NORTH || this == NORTH_EAST || this == NORTH_WEST;
    }

    public boolean isSouth() {
        return this == SOUTH || this == SOUTH_EAST || this == SOUTH_WEST;
    }

    public boolean isEast() {
        return this.isEast(true);
    }

    public boolean isWest() {
        return this.isWest(true);
    }

    public boolean isEast(boolean includePureDirections) {
        return this == EAST && includePureDirections || this == NORTH_EAST || this == SOUTH_EAST;
    }

    public boolean isWest(boolean includePureDirections) {
        return this == WEST && includePureDirections || this == NORTH_WEST || this == SOUTH_WEST;
    }

    public boolean isVertical() {
        return this == NORTH || this == SOUTH;
    }

    public boolean isHorizontal() {
        return this == EAST || this == WEST;
    }

    public boolean isDiagonal() {
        return !this.isVertical() && !this.isHorizontal();
    }

    public double getAngle() {
        return Math.toRadians(this.getDegreeAngle());
    }

    public int getDegreeAngle() {
        return switch (this) {
            case SOUTH -> 180;
            case EAST -> 90;
            case WEST -> 270;
            case NORTH_EAST -> 45;
            case NORTH_WEST -> 315;
            case SOUTH_EAST -> 135;
            case SOUTH_WEST -> 225;
            default -> 0;
        };
    }
}

