/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public final class PropertyUtil {
    public static boolean canOverwrite(Object o) {
        return o == null || o instanceof UIResource;
    }

    public static void installSystemProperty(String key, String value) {
        String current = System.getProperty(key);
        if (current == null) {
            System.setProperty(key, value);
        }
    }

    public static void installBackground(Component component, Color color) {
        if (component == null || color == null) {
            return;
        }
        component.setBackground(PropertyUtil.chooseColor(component.getBackground(), color));
    }

    public static void installForeground(Component component, Color color) {
        if (component == null || color == null) {
            return;
        }
        component.setForeground(PropertyUtil.chooseColor(component.getForeground(), color));
    }

    public static void installBorder(JComponent component, Border border) {
        if (component == null) {
            return;
        }
        Border b = component.getBorder();
        if (PropertyUtil.canOverwrite(b)) {
            component.setBorder(border);
        }
    }

    public static void installFont(Component component, Font font) {
        if (component == null) {
            return;
        }
        Font f = component.getFont();
        if (PropertyUtil.canOverwrite(f)) {
            component.setFont(font);
        }
    }

    public static void uninstallProperty(JComponent c, String key) {
        PropertyUtil.installProperty(c, key, null);
    }

    public static void installProperty(JComponent c, String key, Object value) {
        if (c == null) {
            return;
        }
        Object current = c.getClientProperty(key);
        if (PropertyUtil.canOverwrite(current)) {
            c.putClientProperty(key, value);
        }
    }

    public static void installBooleanProperty(JComponent c, String key, String valueKey) {
        PropertyUtil.installProperty(c, key, new UIResourceString(String.valueOf(UIManager.getBoolean(valueKey))));
    }

    public static boolean getBooleanProperty(Component c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(Component c, String property, boolean defaultValue) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            return PropertyUtil.getBooleanProperty(jc, property, defaultValue);
        }
        return false;
    }

    public static boolean getBooleanProperty(JComponent c, String property) {
        return PropertyUtil.getBooleanProperty(c, property, false);
    }

    public static boolean getBooleanProperty(JComponent c, String property, boolean defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return PropertyUtil.parseBooleanProperty(c.getClientProperty(property), defaultValue);
    }

    public static boolean parseBooleanProperty(Object value, boolean defaultValue) {
        Object obj = value;
        if (!(obj instanceof Boolean) && obj != null) {
            obj = Boolean.parseBoolean(obj.toString());
        }
        if (!defaultValue) {
            return Boolean.TRUE.equals(obj);
        }
        return !Boolean.FALSE.equals(obj);
    }

    public static <T> boolean isPropertyEqual(Component c, String property, T checkValue) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            return PropertyUtil.isPropertyEqual(jc, property, checkValue);
        }
        return false;
    }

    public static <T> boolean isPropertyEqual(JComponent c, String property, T checkValue) {
        if (c == null) {
            return false;
        }
        Object obj = c.getClientProperty(property);
        return Objects.equals(checkValue, obj);
    }

    public static <T> T getObject(Component c, Object key, Class<T> type, T defaultValue) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            return PropertyUtil.getObject(jc, key, type, defaultValue);
        }
        return defaultValue;
    }

    public static <T> T getObject(JComponent c, Object key, Class<T> type, T defaultValue) {
        Object obj = c.getClientProperty(key);
        if (type.isInstance(obj)) {
            return type.cast(obj);
        }
        return defaultValue;
    }

    public static Object getObject(Component c, String key) {
        return PropertyUtil.getObject(c, (Object)key, Object.class, null);
    }

    public static Color getColor(JComponent c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, Color.class, defaultValue);
    }

    public static Color getColor(Component c, String key, Color defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, Color.class, defaultValue);
    }

    public static String getString(JComponent c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, String.class, defaultValue);
    }

    public static String getString(Component c, String key, String defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, String.class, defaultValue);
    }

    public static <T> T getObject(Component c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, (Object)key, type, null);
    }

    public static <T> T getObject(JComponent c, String key, Class<T> type) {
        return PropertyUtil.getObject(c, (Object)key, type, null);
    }

    public static Color getColor(JComponent c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static Color getColor(Component c, String key) {
        return PropertyUtil.getColor(c, key, null);
    }

    public static String getString(JComponent c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static String getString(Component c, String key) {
        return PropertyUtil.getString(c, key, null);
    }

    public static Integer getInteger(JComponent c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key, int defaultValue) {
        return PropertyUtil.getObject(c, (Object)key, Integer.class, Integer.valueOf(defaultValue));
    }

    public static Integer getInteger(Component c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }

    public static Integer getInteger(JComponent c, String key) {
        return PropertyUtil.getInteger(c, key, 0);
    }

    public static <T> List<T> getList(UIDefaults defaults, String key, Class<T> type) {
        Object obj = defaults.get(key);
        if (!(obj instanceof List)) {
            return Collections.emptyList();
        }
        List list = (List)obj;
        return PropertyUtil.asTypedList(list, type);
    }

    public static <T> List<T> asTypedList(List<?> list, Class<T> type) {
        return list.stream().filter(Objects::nonNull).filter(t -> type.isAssignableFrom(t.getClass())).map(type::cast).collect(Collectors.toList());
    }

    public static Color chooseColor(Color currentColor, Color newColor) {
        if (ColorUtil.canOverwriteColor(currentColor)) {
            return newColor;
        }
        return currentColor;
    }

    public static Integer getMnemonic(UIDefaults defaults, String key, Locale l) {
        return PropertyUtil.parseMnemonic(defaults.get(key, l));
    }

    public static Integer getMnemonic(String key, Locale l) {
        return PropertyUtil.parseMnemonic(UIManager.get(key, l));
    }

    private static Integer parseMnemonic(Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i;
        }
        if (value instanceof String) {
            String s = (String)value;
            return Integer.parseInt(s);
        }
        return -1;
    }

    public static boolean getSystemFlag(String key) {
        return PropertyUtil.getSystemFlag(key, true);
    }

    public static boolean getSystemFlag(String key, boolean defaultValue) {
        if (defaultValue) {
            return !"false".equals(System.getProperty(key));
        }
        return "true".equals(System.getProperty(key));
    }

    private record UIResourceString(String value) implements UIResource
    {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UIResourceString)) {
                return false;
            }
            UIResourceString that = (UIResourceString)o;
            return Objects.equals(this.value, that.value);
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

