/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.NativeUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JNIDecorationsWindows {
    private static final Logger LOGGER = Logger.getLogger(JNIDecorationsWindows.class.getName());
    private static boolean loaded;
    private static boolean attemptedLoad;

    public static native void updateValues(long var0, int var2, int var3, int var4);

    public static native void setResizable(long var0, boolean var2);

    public static native void setBackground(long var0, int var2, int var3, int var4);

    public static native void minimize(long var0);

    public static native void maximize(long var0);

    public static native void restore(long var0);

    public static native void installDecorations(long var0);

    public static native void uninstallDecorations(long var0);

    public static native void installPopupMenuDecorations(long var0);

    public static void updateLibrary() {
        if (!loaded && !attemptedLoad) {
            JNIDecorationsWindows.loadLibrary();
        }
    }

    private static void loadLibrary() {
        attemptedLoad = true;
        if (!SystemInfo.isWindows || loaded) {
            return;
        }
        try {
            if (SystemInfo.isX86) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-windows/windows-x86/darklaf-windows.dll");
            } else if (SystemInfo.isX64) {
                NativeUtil.loadLibraryFromJar((String)"/com/github/weisj/darklaf/platform/darklaf-windows/windows-x86-64/darklaf-windows.dll");
            } else {
                LOGGER.warning("Could not determine jre model '" + SystemInfo.jreArchitecture + "'. Decorations will be disabled");
                return;
            }
            loaded = true;
            LOGGER.info("Loaded darklaf-windows.dll. Decorations are enabled.");
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load decorations library darklaf-windows.dll. Decorations will be disabled", e);
        }
    }

    public static boolean isCustomDecorationSupported() {
        return loaded;
    }
}

