/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.nativeutil.AbstractLibrary;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.util.LogUtil;

public class WindowsLibrary
extends AbstractLibrary {
    private static final String PATH = "/com/github/weisj/darklaf/platform/darklaf-windows";
    private static final String x86_PATH = "/com/github/weisj/darklaf/platform/darklaf-windows/darklaf-windows-x86.dll";
    private static final String x86_64_PATH = "/com/github/weisj/darklaf/platform/darklaf-windows/darklaf-windows-x86-64.dll";
    private static final WindowsLibrary library = new WindowsLibrary();

    public static WindowsLibrary get() {
        return library;
    }

    protected WindowsLibrary() {
        super("darklaf-windows", LogUtil.getLogger(WindowsLibrary.class));
    }

    protected void afterLoad() {
        JNIDecorationsWindows.init();
        SystemInfo.setWindows11State((boolean)JNIDecorationsWindows.isWindows11());
    }

    protected final Class<?> getLoaderClass() {
        return WindowsLibrary.class;
    }

    protected String getX86Path() {
        return x86_PATH;
    }

    protected String getX64Path() {
        return x86_64_PATH;
    }

    public String getLibraryPath() {
        if (SystemInfo.isX86) {
            return this.getX86Path();
        }
        if (SystemInfo.isX64) {
            return this.getX64Path();
        }
        throw new IllegalStateException("Unsupported arch");
    }

    protected boolean canLoad() {
        return !SystemInfo.undefinedArchitecture && SystemInfo.isX86Compatible && SystemInfo.isWindows10OrGreater;
    }
}

