/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg;

import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Font;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SVGDocument {
    private static final boolean DEBUG = false;
    @NotNull
    private final SVG root;

    public SVGDocument(@NotNull SVG root) {
        this.root = root;
    }

    @NotNull
    public FloatSize size() {
        float em = SVGFont.defaultFontSize();
        return this.root.sizeForTopLevel(em, SVGFont.exFromEm(em));
    }

    public void render(@Nullable JComponent component, @NotNull Graphics2D g) {
        this.render(component, g, null);
    }

    public void render(@Nullable JComponent component, @NotNull Graphics2D g, @Nullable ViewBox bounds) {
        Font f = g.getFont();
        if (f == null && component != null) {
            f = component.getFont();
        }
        float defaultEm = f != null ? f.getSize2D() : SVGFont.defaultFontSize();
        float defaultEx = SVGFont.exFromEm(defaultEm);
        MeasureContext initialMeasure = bounds != null ? MeasureContext.createInitial(bounds.size(), defaultEm, defaultEx) : MeasureContext.createInitial(this.root.sizeForTopLevel(defaultEm, defaultEx), defaultEm, defaultEx);
        RenderContext context = RenderContext.createInitial(component, initialMeasure);
        if (bounds == null) {
            bounds = new ViewBox(this.root.size(context));
        }
        this.root.applyTransform(g, initialMeasure);
        g.clip(bounds);
        g.translate(bounds.x, bounds.y);
        this.root.renderWithSize(bounds.size(), this.root.viewBox(), context, g);
    }
}

