/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.geometry.size.Length;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkerOrientation {
    private MarkerOrientation() {
    }

    @NotNull
    public static MarkerOrientation parse(@Nullable String value, @NotNull AttributeParser parser) {
        if (value == null) {
            return AngleOrientation.DEFAULT;
        }
        if ("auto".equals(value)) {
            return AutoOrientation.INSTANCE;
        }
        if ("auto-start-reverse".equals(value)) {
            return AutoStartReverseOrientation.INSTANCE;
        }
        float angle = parser.parseAngle(value, Float.NaN);
        if (Length.isSpecified(angle)) {
            return new AngleOrientation(angle);
        }
        return AngleOrientation.DEFAULT;
    }

    public abstract float orientationFor(@NotNull MarkerType var1, float var2, float var3, float var4, float var5);

    private static final class AngleOrientation
    extends MarkerOrientation {
        @NotNull
        private static final AngleOrientation DEFAULT = new AngleOrientation(0.0f);
        private final float angle;

        private AngleOrientation(float angle) {
            this.angle = angle;
        }

        @Override
        public float orientationFor(@NotNull MarkerType type, float dxIn, float dyIn, float dxOut, float dyOut) {
            return this.angle;
        }
    }

    private static final class AutoOrientation
    extends MarkerOrientation {
        @NotNull
        private static final AutoOrientation INSTANCE = new AutoOrientation();

        private AutoOrientation() {
        }

        @Override
        public float orientationFor(@NotNull MarkerType type, float dxIn, float dyIn, float dxOut, float dyOut) {
            switch (type) {
                case Start: {
                    return (float)Math.atan2(dyOut, dxOut);
                }
                case End: {
                    return (float)Math.atan2(dyIn, dxIn);
                }
                case Mid: {
                    return (float)Math.atan2((dyIn + dyOut) / 2.0f, (dxIn + dxOut) / 2.0f);
                }
            }
            throw new IllegalStateException();
        }
    }

    private static final class AutoStartReverseOrientation
    extends MarkerOrientation {
        @NotNull
        private static final AutoStartReverseOrientation INSTANCE = new AutoStartReverseOrientation();

        private AutoStartReverseOrientation() {
        }

        @Override
        public float orientationFor(@NotNull MarkerType type, float dxIn, float dyIn, float dxOut, float dyOut) {
            switch (type) {
                case Start: {
                    return (float)Math.atan2(-dyOut, -dxOut);
                }
                case End: {
                    return (float)Math.atan2(dyIn, dxIn);
                }
                case Mid: {
                    return (float)Math.atan2((dyIn + dyOut) / 2.0f, (dxIn + dxOut) / 2.0f);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum MarkerType {
        Start,
        Mid,
        End;

    }
}

